/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.data_gen;

import com.google.gson.JsonObject;
import com.robertx22.mine_and_slash.onevent.data_gen.IFromRegistrySerializable;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;

public interface ISerializedRegistryEntry<T>
extends ISlashRegistryEntry<T>,
IFromRegistrySerializable<T> {
    default public void addToSerializables() {
        SlashRegistry.getRegistry(this.getSlashRegistryType()).addSerializable(this);
    }

    @Override
    default public JsonObject toRegistryJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.GUID());
        json.addProperty("registry", this.getSlashRegistryType().id);
        return json;
    }

    @Override
    default public T fromRegistryJson(JsonObject json) {
        SlashRegistryType type = SlashRegistryType.getFromString(json.get("registry").getAsString());
        String id = json.get("id").getAsString();
        return (T)SlashRegistry.get(type, id);
    }
}

