/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.entity;

import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.loot.MasterLootGen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.CriteriaRegisters;
import com.robertx22.mine_and_slash.packets.DmgNumPacket;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.capability.entity.BossCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.AntiMobFarmCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TeamUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OnMobDeathDrops {
    @SubscribeEvent
    public static void mobOnDeathDrop(LivingDeathEvent event) {
        try {
            EntityCap.UnitData mobKilledData;
            Entity killerEntity;
            LivingEntity mobKilled = event.getEntityLiving();
            if (mobKilled.field_70170_p.field_72995_K) {
                return;
            }
            if (!(mobKilled instanceof PlayerEntity) && Load.hasUnit((ICapabilityProvider)mobKilled) && (killerEntity = (mobKilledData = Load.Unit((ICapabilityProvider)mobKilled)).getHighestDamageEntity((Entity)mobKilled)) instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)killerEntity;
                EntityCap.UnitData playerData = Load.Unit((ICapabilityProvider)player);
                BossCap.IBossData boss = Load.boss((ICapabilityProvider)mobKilled);
                CriteriaRegisters.DROP_LVL_PENALTY_TRIGGER.trigger(player, playerData, mobKilledData);
                CriteriaRegisters.KILL_RARITY_MOB_TRIGGE.trigger(player, mobKilledData);
                CriteriaRegisters.KILL_BOSS_TRIGGER.trigger(player, boss);
                ModEntityConfig config = SlashRegistry.getEntityConfig(mobKilled, mobKilledData);
                float loot_multi = (float)config.LOOT_MULTI;
                float exp_multi = (float)config.EXP_MULTI;
                if (loot_multi > 0.0f || exp_multi > 0.0f) {
                    player.field_70170_p.getCapability(AntiMobFarmCap.Data).ifPresent(x -> x.onValidMobDeathByPlayer(mobKilled));
                }
                if (loot_multi > 0.0f) {
                    MasterLootGen.genAndDrop(mobKilledData, playerData, mobKilled, (PlayerEntity)player);
                }
                if (exp_multi > 0.0f) {
                    OnMobDeathDrops.GiveExp(mobKilled, (PlayerEntity)player, playerData, mobKilledData, exp_multi);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void GiveExp(LivingEntity victim, PlayerEntity killer, EntityCap.UnitData killerData, EntityCap.UnitData mobData, float multi) {
        int exp = (int)((float)mobData.getLevel() * ((MobRarity)Rarities.Mobs.get(mobData.getRarity())).ExpOnKill() * multi);
        exp = (int)LootUtils.ApplyLevelDistancePunishment(mobData, killerData, exp);
        exp = (int)((float)exp * (1.0f + victim.func_110138_aP() / 20.0f));
        try {
            exp = (int)((float)exp * Load.antiMobFarm(victim.field_70170_p).getDropMultiForMob(victim));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (victim instanceof SlimeEntity) {
            exp /= 10;
        }
        if (WorldUtils.isMapWorldClass((IWorld)victim.field_70170_p)) {
            exp = (int)((float)exp * Load.world(killer.field_70170_p).getExpMultiplier(victim.func_180425_c(), (IWorld)victim.field_70170_p));
        }
        if (exp > 0) {
            List<PlayerEntity> list = TeamUtils.getOnlineTeamMembers(killer);
            exp = (int)((float)exp * (0.8f + 0.2f * (float)list.size()));
            if ((exp /= list.size()) > 0) {
                DmgNumPacket packet = new DmgNumPacket(victim, Elements.Nature, "+" + NumberUtils.formatNumber(exp) + " Exp!");
                packet.isExp = true;
                MMORPG.sendToClient(packet, (ServerPlayerEntity)killer);
                for (PlayerEntity x : list) {
                    Load.Unit((ICapabilityProvider)x).PostGiveExpEvent(victim, x, exp);
                }
            }
        }
    }
}

