/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.entity;

import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.onevent.ontick.OnBossTick;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.capability.entity.BossCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OnMobSpawn {
    @SubscribeEvent
    public static void onMobSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getEntity() instanceof PlayerEntity) {
            return;
        }
        LivingEntity entity = (LivingEntity)event.getEntity();
        OnMobSpawn.setupNewMobOnSpawn(entity);
        if (WorldUtils.isMapWorldClass((IWorld)entity.field_70170_p) && entity instanceof MobEntity) {
            MobEntity mob = (MobEntity)entity;
            mob.func_110163_bv();
            OnMobSpawn.setupMobGoals((MobEntity)entity);
        }
    }

    public static void setupNewMobOnSpawn(LivingEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            throw new RuntimeException("Don't run this code on client!");
        }
        EntityCap.UnitData endata = Load.Unit((ICapabilityProvider)entity);
        if (endata != null) {
            if (endata.getUnit() != null) {
                endata.getUnit().removeUnregisteredStats();
            }
            BossCap.IBossData boss = Load.boss((ICapabilityProvider)entity);
            boss.onMobCreation(entity);
            if (boss.isBoss()) {
                OnBossTick.bossList.add((Object)entity);
            }
            endata.setType(entity);
            PlayerEntity nearestPlayer = null;
            WorldMapCap.IWorldMapData mapData = Load.world(entity.field_70170_p);
            nearestPlayer = PlayerUtils.nearestPlayer((ServerWorld)entity.field_70170_p, entity);
            if (endata.needsToBeGivenStats()) {
                Unit unit = OnMobSpawn.Mob(entity, endata, boss, mapData, nearestPlayer);
            } else {
                if (endata.getUnit() == null) {
                    endata.setUnit(new Unit(), entity);
                }
                endata.getUnit().initStats();
                endata.forceRecalculateStats(entity);
            }
            if (boss.isBoss()) {
                endata.setRarity(-2);
            }
        }
    }

    public static void setupMobGoals(MobEntity en) {
        int count = en.field_70714_bg.field_220892_d.size();
        for (PrioritizedGoal x : new HashSet(en.field_70714_bg.field_220892_d)) {
            Goal g = x.func_220772_j();
            if (!(g instanceof RandomWalkingGoal) && !(g instanceof BreakDoorGoal)) continue;
            en.field_70714_bg.func_85156_a(g);
        }
    }

    public static Unit Mob(LivingEntity entity, EntityCap.UnitData data, BossCap.IBossData boss, WorldMapCap.IWorldMapData mapData, @Nullable PlayerEntity nearestPlayer) {
        Unit mob = new Unit();
        mob.initStats();
        EntityCap.UnitData endata = Load.Unit((ICapabilityProvider)entity);
        if (WorldUtils.isMapWorldClass((IWorld)entity.field_70170_p)) {
            endata.setTier(mapData.getTier(entity.func_180425_c(), (IWorld)entity.field_70170_p));
        }
        endata.SetMobLevelAtSpawn(mapData, entity, nearestPlayer);
        int rar = mob.randomRarity(entity, endata, boss);
        endata.setRarity(rar);
        MobRarity rarity = (MobRarity)Rarities.Mobs.get(rar);
        mob.setRandomMobAffixes(rarity);
        endata.setUnit(mob, entity);
        mob.recalculateStats(entity, endata, endata.getLevel(), null);
        return mob;
    }
}

