/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.entity.damage;

import com.robertx22.mine_and_slash.a_libraries.curios.MyCurioUtils;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.config.mod_dmg_whitelist.ModDmgWhitelistContainer;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.MyDamageSource;
import com.robertx22.mine_and_slash.onevent.entity.damage.DamageEventData;
import com.robertx22.mine_and_slash.onevent.entity.damage.DmgSourceUtils;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.BossCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LivingHurtUtils {
    public static void onBossHurt(LivingEntity en) {
        en.getCapability(BossCap.Data).ifPresent(x -> x.onHealthChanged(en, (BossCap.IBossData)x));
    }

    public static void stopMobInWallDamageInMaps(LivingHurtEvent event) {
        try {
            if (event.getSource().equals(DamageSource.field_76368_d) && !(event.getEntityLiving() instanceof PlayerEntity) && WorldUtils.isMapWorldClass((IWorld)event.getEntityLiving().field_70170_p)) {
                event.setCanceled(true);
                event.getEntityLiving().func_70653_a((Entity)event.getEntityLiving(), 1.0f, (double)RandomUtils.RandomRange(-2, 2), (double)RandomUtils.RandomRange(-2, 2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void damageCurioItems(LivingEntity en) {
        if (en instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)en;
            List<ItemStack> curios = MyCurioUtils.getAllSlots(player);
            curios.forEach(x -> x.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND)));
        }
    }

    public static void damageArmorItems(LivingEntity en) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        en.func_184193_aE().forEach(x -> stacks.add((ItemStack)x));
        stacks.add(en.func_184592_cb());
        stacks.forEach(x -> x.func_222118_a(1, en, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND)));
    }

    public static void onAttack(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (target.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getSource() != null) {
            if (LivingHurtUtils.isForbiddenAttack(event)) {
                return;
            }
            if (event.getSource() instanceof MyDamageSource || event.getSource().func_76355_l().equals(DamageEffect.dmgSourceName)) {
                return;
            }
            if (event.getSource().func_76346_g() instanceof LivingEntity) {
                LivingEntity source = (LivingEntity)event.getSource().func_76346_g();
                LivingHurtUtils.onAttack(new DamageEventData(event));
            }
        }
    }

    public static void onAttack(DamageEventData data) {
        try {
            if (!data.target.func_70089_S()) {
                return;
            }
            GearItemData weapondata = data.weaponData;
            data.targetData.tryRecalculateStats(data.target);
            data.sourceData.tryRecalculateStats(data.source);
            if (data.source instanceof PlayerEntity) {
                ItemStack weapon;
                ModDmgWhitelistContainer.ModDmgWhitelist mod;
                if (weapondata == null && (mod = ModDmgWhitelistContainer.getModDmgWhitelist(weapon = data.weapon)) != null) {
                    return;
                }
                if (data.sourceData.isWeapon(weapondata)) {
                    if (data.sourceData.tryUseWeapon(weapondata, data.source)) {
                        data.sourceData.attackWithWeapon(data);
                    }
                } else {
                    if (data.source instanceof FakePlayer) {
                        data.sourceData.mobBasicAttack(data);
                    }
                    data.sourceData.unarmedAttack(data);
                }
            } else {
                data.sourceData.mobBasicAttack(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isForbiddenAttack(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity en = (LivingEntity)event.getSource().func_76346_g();
            DamageSource source = event.getSource();
            Item item = en.func_184614_ca().func_77973_b();
            if (item instanceof BowItem || item instanceof CrossbowItem) {
                if (source.field_76373_n.contains("arrow")) {
                    return false;
                }
                if (source.field_76373_n.contains("bolt")) {
                    return false;
                }
                if (source.field_76373_n.contains("ammo")) {
                    return false;
                }
                if (source.field_76373_n.contains("bullet")) {
                    return false;
                }
                if (source.field_76373_n.contains("firework")) {
                    return false;
                }
                if (source.field_76373_n.contains("dart")) {
                    return false;
                }
                return !source.field_76373_n.contains("missile");
            }
            if (source instanceof IndirectEntityDamageSource) {
                IndirectEntityDamageSource indi = (IndirectEntityDamageSource)source;
                return !(indi.func_76364_f() instanceof TridentEntity);
            }
        }
        return false;
    }

    public static void modifyDamage(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getSource() == null) {
            return;
        }
        if (DmgSourceUtils.isMyDmgSource(event.getSource())) {
            DmgSourceUtils.removeSourceMarker(event.getSource());
            LivingHurtUtils.damageArmorItems(event.getEntityLiving());
            return;
        }
        if (LivingHurtUtils.isEnviromentalDmg(event.getSource())) {
            if (!(event.getEntity() instanceof PlayerEntity)) {
                event.setAmount(event.getAmount() * ((Double)ModConfig.INSTANCE.Server.MOB_ENVIRONMENT_DAMAGE_MULTI.get()).floatValue());
                return;
            }
        } else {
            LivingEntity en = (LivingEntity)event.getSource().func_76346_g();
            ModDmgWhitelistContainer.ModDmgWhitelist mod = ModDmgWhitelistContainer.getModDmgWhitelist(en.func_184614_ca());
            if (mod != null) {
                event.setAmount(event.getAmount() * mod.dmgMultiplier);
                return;
            }
            event.setAmount(event.getAmount() * ((Double)ModConfig.INSTANCE.Server.NON_MOD_DAMAGE_MULTI.get()).floatValue());
            return;
        }
    }

    public static boolean isEnviromentalDmg(DamageSource source) {
        return !(source.func_76346_g() instanceof LivingEntity);
    }

    public static void onHurtRecordNonPlayerDmg(LivingHurtEvent event) {
        LivingEntity defender = event.getEntityLiving();
        EntityCap.UnitData data = Load.Unit((ICapabilityProvider)defender);
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            data.onDamagedBy(attacker, event.getAmount(), defender);
        } else {
            data.onDamagedBy(null, event.getAmount(), defender);
        }
    }
}

