/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.item;

import com.robertx22.mine_and_slash.database.currency.base.ICurrencyItemEffect;
import com.robertx22.mine_and_slash.new_content.trader.ISellPrice;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OnTooltip {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltip(ItemTooltipEvent event) {
        OnTooltip.buildDataTootltip(event);
        OnTooltip.buildCurrencyEffectTooltip(event);
        ItemStack stack = event.getItemStack();
        if (ISellPrice.hasPrice(stack)) {
            event.getToolTip().add(new SText(""));
            event.getToolTip().add(new SText(""));
        }
    }

    private static void buildDataTootltip(ItemTooltipEvent event) {
        try {
            GearItemData gear;
            if (Screen.hasControlDown() && (gear = Gear.Load(event.getItemStack())) != null) {
                return;
            }
            if (event.getPlayer() == null || event.getPlayer().field_70170_p == null || !event.getPlayer().field_70170_p.field_72995_K) {
                return;
            }
            ItemStack stack = event.getItemStack();
            EntityCap.UnitData unitdata = Load.Unit((ICapabilityProvider)event.getPlayer());
            if (unitdata == null) {
                return;
            }
            Unit unit = unitdata.getUnit();
            if (unit == null) {
                return;
            }
            TooltipContext ctx = new TooltipContext(stack, event, unitdata);
            if (!stack.func_77942_o()) {
                return;
            }
            ICommonDataItem data = ICommonDataItem.load(stack);
            if (data != null) {
                data.BuildTooltip(ctx);
            } else if (stack.func_77973_b().getRegistryName() != null && SlashRegistry.CompatibleItems().isRegistered(stack.func_77973_b().getRegistryName().toString())) {
                event.getToolTip().add(new StringTextComponent(Styles.RED + "Compatible Mine and Slash Item"));
            }
            ITextComponent broken = TooltipUtils.itemBrokenText(stack, data);
            if (broken != null) {
                event.getToolTip().add(broken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildCurrencyEffectTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof ICurrencyItemEffect) {
            ICurrencyItemEffect currency = (ICurrencyItemEffect)event.getItemStack().func_77973_b();
            currency.addToTooltip(event.getToolTip());
        }
    }
}

