/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.my_events;

import com.robertx22.mine_and_slash.a_libraries.curios.MyCurioUtils;
import com.robertx22.mine_and_slash.api.MineAndSlashEvents;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CollectGearEvent {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void collectStacks(MineAndSlashEvents.CollectGearStacksEvent event) {
        CollectGearEvent.getEquipsExcludingWeapon(event.getEntityLiving()).forEach(x -> event.add((ItemStack)x));
        CollectGearEvent.addHeldItems(event);
    }

    public static List<ItemStack> getEquipsExcludingWeapon(LivingEntity entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack == null) continue;
            list.add(stack);
        }
        if (entity instanceof PlayerEntity) {
            list.addAll(MyCurioUtils.getAllSlots((PlayerEntity)entity));
        }
        return list;
    }

    public static void addHeldItems(MineAndSlashEvents.CollectGearStacksEvent event) {
        boolean hasWep = false;
        if (event.data != null && event.data.weaponData != null) {
            event.add(event.data.weaponData);
            hasWep = true;
        }
        if (!hasWep) {
            GearItemData wep;
            ItemStack weapon = event.getEntityLiving().func_184614_ca();
            if (MineAndSlashEvents.CollectGearStacksEvent.isStackValidGear(weapon) && (wep = Gear.Load(weapon)) != null && wep.GetBaseGearType() != null && wep.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)) {
                hasWep = true;
                event.add(wep);
            }
        }
        ItemStack offhand = event.getEntityLiving().func_184592_cb();
        if (MineAndSlashEvents.CollectGearStacksEvent.isStackValidGear(offhand)) {
            GearItemData off = Gear.Load(offhand);
            if (off != null && off.GetBaseGearType() != null && off.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.OffHand)) {
                event.add(off);
            } else if (off != null && off.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)) {
                event.getEntityLiving().func_145747_a((ITextComponent)new StringTextComponent("You can't wear a weapon in offhand."));
            }
        }
    }
}

