/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.ontick;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.stats.types.resources.EnergyRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.HealthRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.ManaRegen;
import com.robertx22.mine_and_slash.new_content.ProcessChunkBlocks;
import com.robertx22.mine_and_slash.potion_effects.all.TeleportProtection;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.capability.bases.CapSyncUtil;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class OnServerTick {
    static final int TicksToUpdatePlayer = 18;
    static final int TicksToRegen = 60;
    static final int TicksToMSRegen = 200;
    static final int TicksToPassMinute = 1200;
    static final int TicksToSpellCooldowns = 1;
    static final int TicksToProcessChunks = 50;
    public static HashMap<UUID, PlayerTickData> PlayerTickDatas = new HashMap();

    @SubscribeEvent
    public static void onTickLogicVoid(TickEvent.PlayerTickEvent event) {
        if (event.side.equals((Object)LogicalSide.SERVER) && event.phase == TickEvent.Phase.END) {
            try {
                ServerPlayerEntity player = (ServerPlayerEntity)event.player;
                PlayerTickData data = PlayerTickDatas.get(player.func_110124_au());
                if (data == null) {
                    data = new PlayerTickData();
                }
                data.increment();
                if (data.msRegenTicks > 200) {
                    data.msRegenTicks = 0;
                    if (player.func_70089_S()) {
                        player.getCapability(EntityCap.Data).ifPresent(x -> {
                            x.forceRecalculateStats((LivingEntity)player);
                            Unit unit = x.getUnit();
                            float magicshieldrestored = unit.peekAtStat(MagicShieldRegen.GUID).getAverageValue();
                            ResourcesData.Context ms = new ResourcesData.Context((EntityCap.UnitData)x, (LivingEntity)player, ResourcesData.Type.MAGIC_SHIELD, magicshieldrestored, ResourcesData.Use.RESTORE);
                            x.getResources().modify(ms);
                        });
                    }
                }
                if (data.regenTicks > 60) {
                    data.regenTicks = 0;
                    if (player.func_70089_S()) {
                        player.getCapability(EntityCap.Data).ifPresent(x -> {
                            boolean canHeal;
                            x.forceRecalculateStats((LivingEntity)player);
                            Unit unit = x.getUnit();
                            float manarestored = unit.peekAtStat(ManaRegen.GUID).getAverageValue();
                            ResourcesData.Context mana = new ResourcesData.Context((EntityCap.UnitData)x, (LivingEntity)player, ResourcesData.Type.MANA, manarestored, ResourcesData.Use.RESTORE);
                            x.getResources().modify(mana);
                            float energyrestored = unit.peekAtStat(EnergyRegen.GUID).getAverageValue();
                            ResourcesData.Context ene = new ResourcesData.Context((EntityCap.UnitData)x, (LivingEntity)player, ResourcesData.Type.ENERGY, energyrestored, ResourcesData.Use.RESTORE);
                            x.getResources().modify(ene);
                            boolean restored = false;
                            boolean bl = canHeal = player.func_71024_bL().func_75116_a() >= 15;
                            if (canHeal) {
                                if (player.func_110143_aJ() < player.func_110138_aP()) {
                                    restored = true;
                                }
                                float missingHp = x.getUnit().getMissingHealth((LivingEntity)player);
                                float healthrestored = unit.peekAtStat(HealthRegen.GUID).getAverageValue();
                                ResourcesData.Context hp = new ResourcesData.Context((EntityCap.UnitData)x, (LivingEntity)player, ResourcesData.Type.HEALTH, healthrestored, ResourcesData.Use.RESTORE);
                                x.getResources().modify(hp);
                                if (restored) {
                                    float hpRegenEffectiveness = MathHelper.func_76131_a((float)(missingHp / healthrestored), (float)0.0f, (float)1.0f);
                                    player.func_71024_bL().func_75113_a(((Double)ModConfig.INSTANCE.Server.REGEN_HUNGER_COST.get()).floatValue() * hpRegenEffectiveness);
                                }
                            }
                        });
                    }
                }
                if (data.ticksToPassMinute > 1200) {
                    data.ticksToPassMinute = 0;
                    Load.playerMapData((PlayerEntity)player).onMinute((PlayerEntity)player);
                    if (player.func_184102_h().func_71264_H()) {
                        SlashRegistry.restoreFromBackupifEmpty();
                    }
                }
                if (data.ticksToProcessChunks > 50) {
                    data.ticksToProcessChunks = 0;
                    if (player.func_70660_b((Effect)TeleportProtection.INSTANCE) == null) {
                        player.func_184224_h(false);
                    }
                    ProcessChunkBlocks.process((LivingEntity)player);
                }
                if (data.ticksToSpellCooldowns >= 1) {
                    data.ticksToSpellCooldowns = 0;
                    player.getCapability(PlayerSpellCap.Data).ifPresent(x -> x.getCastingData().onTimePass((PlayerEntity)player, (PlayerSpellCap.ISpellsCap)x, 1));
                }
                if (data.playerSyncTick > 18) {
                    data.playerSyncTick = 0;
                    CapSyncUtil.syncAll((PlayerEntity)player);
                }
                PlayerTickDatas.put(player.func_110124_au(), data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class PlayerTickData {
        public int regenTicks = 0;
        public int msRegenTicks = 0;
        public int playerSyncTick = 0;
        public int ticksToPassMinute = 0;
        public int ticksToSpellCooldowns = 0;
        public int ticksToProcessChunks = 0;

        PlayerTickData() {
        }

        public void increment() {
            ++this.regenTicks;
            ++this.msRegenTicks;
            ++this.playerSyncTick;
            ++this.ticksToPassMinute;
            ++this.ticksToProcessChunks;
            ++this.ticksToSpellCooldowns;
        }
    }
}

