/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.onevent.player;

import com.robertx22.mine_and_slash.new_content.chests.MapChestBlock;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OnDungeonBlockEvents {
    public static boolean canBreakBlock(Block block) {
        try {
            ResourceLocation id = block.getRegistryName();
            String namespace = id.func_110624_b();
            if (namespace.contains("grave") || namespace.contains("tomb")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return block instanceof MapChestBlock;
    }

    private static boolean isDungeon(Entity entity) {
        return entity != null && WorldUtils.isMapWorldClass((IWorld)entity.field_70170_p);
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        try {
            if (OnDungeonBlockEvents.isDungeon((Entity)event.getPlayer())) {
                if (event.getPlayer().func_184812_l_()) {
                    return;
                }
                boolean can = OnDungeonBlockEvents.canBreakBlock(event.getState().func_177230_c());
                if (!can) {
                    event.setCanceled(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        if (OnDungeonBlockEvents.isDungeon(event.getEntity())) {
            PlayerEntity player;
            if (event.getEntity() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntity()).func_184812_l_()) {
                return;
            }
            event.setCanceled(true);
        }
    }
}

