/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets;

import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class BossPacket {
    public int id;
    public CompoundNBT nbt;

    public BossPacket() {
    }

    public BossPacket(Entity entity) {
        this.id = entity.func_145782_y();
        this.nbt = Load.boss((ICapabilityProvider)entity).saveToNBT();
    }

    public static BossPacket decode(PacketBuffer buf) {
        BossPacket newpkt = new BossPacket();
        newpkt.id = buf.readInt();
        newpkt.nbt = buf.func_150793_b();
        return newpkt;
    }

    public static void encode(BossPacket packet, PacketBuffer tag) {
        tag.writeInt(packet.id);
        tag.func_150786_a(packet.nbt);
    }

    public static void handle(BossPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                Entity entity = MMORPG.proxy.getPlayerEntityFromContext((Supplier<NetworkEvent.Context>)ctx).field_70170_p.func_73045_a(pkt.id);
                if (entity instanceof LivingEntity) {
                    LivingEntity en = (LivingEntity)entity;
                    Load.boss((ICapabilityProvider)en).loadFromNBT(pkt.nbt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

