/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.robertx22.mine_and_slash.database.rarities.RarityTypeEnum;
import com.robertx22.mine_and_slash.onevent.data_gen.ISerializable;
import com.robertx22.mine_and_slash.saveclasses.ListStringData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class RarityPacket {
    static final JsonParser PARSER = new JsonParser();
    RarityTypeEnum type;
    ListStringData data;

    private RarityPacket() {
    }

    public RarityPacket(RarityTypeEnum type) {
        List<String> list = type.container.getAllRarities().stream().map(x -> ((ISerializable)x).toJson().toString()).collect(Collectors.toList());
        if (list.isEmpty()) {
            throw new RuntimeException("Rarity Registry is empty on the server when trying to send registry packet!");
        }
        this.data = new ListStringData(list);
        this.type = type;
    }

    public static RarityPacket decode(PacketBuffer buf) {
        try {
            RarityPacket newpkt = new RarityPacket();
            newpkt.type = RarityTypeEnum.valueOf(buf.func_150789_c(30));
            CompoundNBT nbt = buf.func_150793_b();
            newpkt.data = LoadSave.Load(ListStringData.class, new ListStringData(), nbt, "data");
            return newpkt;
        }
        catch (Exception e) {
            System.out.println("Failed reading Mine and Slash packet to bufferer.");
            e.printStackTrace();
            return new RarityPacket();
        }
    }

    public static void encode(RarityPacket packet, PacketBuffer tag) {
        try {
            tag.func_211400_a(packet.type.name(), 30);
            CompoundNBT nbt = new CompoundNBT();
            LoadSave.Save(packet.data, nbt, "data");
            tag.func_150786_a(nbt);
        }
        catch (Exception e) {
            System.out.println("Failed saving " + packet.type.name() + " Mine and Slash packet to bufferer.");
            e.printStackTrace();
        }
    }

    public static void handle(RarityPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                if (pkt.data.getList().isEmpty()) {
                    throw new RuntimeException("Rarity list sent from server is empty!");
                }
                List list = pkt.data.getList().stream().map(x -> {
                    try {
                        JsonObject json = (JsonObject)PARSER.parse(x);
                        return (Rarity)pkt.type.serializer.fromJson(json);
                    }
                    catch (JsonSyntaxException e) {
                        System.out.println("Failed to parse Mine and Slash rarity Json!!!");
                        e.printStackTrace();
                        return null;
                    }
                }).collect(Collectors.toList());
                pkt.type.container.updateFromDatapack(list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

