/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets;

import com.robertx22.mine_and_slash.blocks.scrabble.ScrabbleTile;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ScrabblePacket {
    public BlockPos pos;
    public String word;

    public ScrabblePacket() {
    }

    public ScrabblePacket(BlockPos pos, String word) {
        this.pos = pos;
        this.word = word;
    }

    public static ScrabblePacket decode(PacketBuffer buf) {
        ScrabblePacket newpkt = new ScrabblePacket();
        newpkt.pos = buf.func_179259_c();
        newpkt.word = buf.func_150789_c(30);
        return newpkt;
    }

    public static void encode(ScrabblePacket packet, PacketBuffer tag) {
        tag.func_179255_a(packet.pos);
        tag.func_211400_a(packet.word, 30);
    }

    public static void handle(ScrabblePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                TileEntity tile;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (tile = player.field_70170_p.func_175625_s(pkt.pos)) instanceof ScrabbleTile) {
                    ScrabbleTile scrabble = (ScrabbleTile)tile;
                    scrabble.tryGuessWord(pkt.word);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

