/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets.allocation.abilities;

import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.packets.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class TryRemoveAbilityPointPacket {
    public String guid;

    public TryRemoveAbilityPointPacket() {
    }

    public TryRemoveAbilityPointPacket(IAbility perk) {
        this.guid = perk.GUID();
    }

    public static TryRemoveAbilityPointPacket decode(PacketBuffer buf) {
        TryRemoveAbilityPointPacket newpkt = new TryRemoveAbilityPointPacket();
        newpkt.guid = buf.func_150789_c(50);
        return newpkt;
    }

    public static void encode(TryRemoveAbilityPointPacket packet, PacketBuffer tag) {
        tag.func_211400_a(packet.guid, 50);
    }

    public static void handle(TryRemoveAbilityPointPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                PlayerSpellCap.ISpellsCap spells = Load.spells((LivingEntity)player);
                IAbility ability = IAbility.fromId(pkt.guid);
                if (ability != null) {
                    EntityCap.UnitData data = Load.Unit((ICapabilityProvider)player);
                    if (spells.getLevelOf(ability) > 0 && spells.getAbilitiesData().resetPoints > 0) {
                        spells.getAbilitiesData().removePoint(ability);
                        MMORPG.sendToClient(new SyncCapabilityToClient(player, PlayerCaps.SPELLS), player);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

