/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets.allocation.schools;

import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.packets.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class TryRemoveSchoolPointPacket {
    public String school;

    public TryRemoveSchoolPointPacket() {
    }

    public TryRemoveSchoolPointPacket(Masteries school) {
        this.school = school.name();
    }

    public static TryRemoveSchoolPointPacket decode(PacketBuffer buf) {
        TryRemoveSchoolPointPacket newpkt = new TryRemoveSchoolPointPacket();
        newpkt.school = buf.func_150789_c(50);
        return newpkt;
    }

    public static void encode(TryRemoveSchoolPointPacket packet, PacketBuffer tag) {
        tag.func_211400_a(packet.school, 50);
    }

    public static void handle(TryRemoveSchoolPointPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                PlayerSpellCap.ISpellsCap spells = Load.spells((LivingEntity)player);
                Masteries school = Masteries.valueOf(pkt.school);
                if (school != null) {
                    EntityCap.UnitData data = Load.Unit((ICapabilityProvider)player);
                    if (spells.getAbilitiesData().canRemoveSchoolPoint(school)) {
                        spells.getAbilitiesData().removeSchoolPoint(school);
                    }
                    MMORPG.sendToClient(new SyncCapabilityToClient(player, PlayerCaps.SPELLS), player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

