/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets.allocation.talents;

import com.robertx22.mine_and_slash.database.talent_tree.BasePerk;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.packets.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerTalentsCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class TryRemoveTalentPacket {
    public String guid;

    public TryRemoveTalentPacket() {
    }

    public TryRemoveTalentPacket(BasePerk perk) {
        this.guid = perk.GUID();
    }

    public static TryRemoveTalentPacket decode(PacketBuffer buf) {
        TryRemoveTalentPacket newpkt = new TryRemoveTalentPacket();
        newpkt.guid = buf.func_150789_c(30);
        return newpkt;
    }

    public static void encode(TryRemoveTalentPacket packet, PacketBuffer tag) {
        tag.func_211400_a(packet.guid, 30);
    }

    public static void handle(TryRemoveTalentPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                PlayerTalentsCap.IPlayerTalentsData talents = Load.talents((PlayerEntity)player);
                Perk talent = SlashRegistry.Perks().get(pkt.guid);
                if (talent != null) {
                    talents.tryRemovePoint(talent, player);
                    MMORPG.sendToClient(new SyncCapabilityToClient(player, PlayerCaps.TALENTS), player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

