/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets.particles;

import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacket;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.RGB;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.GeometryUtils;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public enum ParticleEnum {
    THORNS{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vec3d center = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vec3d p = GeometryUtils.randomPos(center, world.field_73012_v, data.radius);
                Vec3d m = GeometryUtils.randomMotion(center, world.field_73012_v);
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196647_Y.func_176223_P()), p.field_72450_a, p.field_72448_b, p.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
                world.func_195594_a((IParticleData)ParticleTypes.field_197592_C, p.field_72450_a, p.field_72448_b, p.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
            }
        }
    }
    ,
    PETRIFY{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vec3d center = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vec3d p = GeometryUtils.randomPos(center, world.field_73012_v, data.radius);
                Vec3d m = GeometryUtils.randomMotion(center, world.field_73012_v);
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150348_b.func_176223_P()), p.field_72450_a, p.field_72448_b, p.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
            }
        }
    }
    ,
    FREEZE{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vec3d center = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vec3d p = GeometryUtils.randomPos(center, world.field_73012_v, data.radius);
                Vec3d m = GeometryUtils.randomMotion(center, world.field_73012_v);
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150432_aD.func_176223_P()), p.field_72450_a, p.field_72448_b, p.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
            }
        }
    }
    ,
    AOE{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vec3d p = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vec3d r = GeometryUtils.getRandomPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                world.func_195594_a(data.getParticleType(), r.field_72450_a, r.field_72448_b, r.field_72449_c, data.mx, data.my, data.mz);
            }
        }
    }
    ,
    CIRCLE_REDSTONE{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vec3d p = this.getCenter(data);
            int i = 0;
            while ((float)i < data.radius * 60.0f) {
                Vec3d r = GeometryUtils.getRandomPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                this.spawnRedstone(world, data.color, r.field_72450_a, r.field_72448_b, r.field_72449_c);
                ++i;
            }
        }
    }
    ,
    NOVA_REDSTONE{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vec3d p = this.getCenter(data);
            int i = 0;
            while ((float)i < data.radius * 50.0f) {
                Vec3d r = GeometryUtils.getRandomHorizontalPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                this.spawnRedstone(world, data.color, r.field_72450_a, r.field_72448_b, r.field_72449_c);
                ++i;
            }
        }
    }
    ,
    NOVA{

        @Override
        public void activate(ParticlePacketData data, World world) {
            Vec3d p = this.getCenter(data);
            for (int i = 0; i < data.amount; ++i) {
                Vec3d r = GeometryUtils.getRandomHorizontalPosInRadiusCircle(p.field_72450_a, p.field_72448_b, p.field_72449_c, data.radius);
                world.func_195594_a(data.getParticleType(), r.field_72450_a, r.field_72448_b, r.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }
    ,
    BLAZING_INFERNO{

        @Override
        public void activate(ParticlePacketData data, World world) {
            for (int i = 0; i < 150; ++i) {
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(data.getPos(), data.radius);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }
    ,
    CHARGED_NOVA{

        @Override
        public void activate(ParticlePacketData data, World world) {
            for (int i = 0; i < 150; ++i) {
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(data.getPos(), data.radius);
                world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }
    ,
    POISON_CLOUD{

        @Override
        public void activate(ParticlePacketData data, World world) {
            for (int i = 0; i < 150; ++i) {
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(data.getPos(), data.radius);
                world.func_195594_a((IParticleData)ParticleTypes.field_218420_D, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197592_C, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197592_C, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197620_m, p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }
    ,
    WHIRLWIND{

        @Override
        public void activate(ParticlePacketData data, World world) {
            for (int i = 0; i < 150; ++i) {
                Vec3d p = GeometryUtils.getRandomHorizontalPosInRadiusCircle(data.getPos(), data.radius);
                world.func_195594_a((IParticleData)ParticleTypes.field_197620_m, p.field_72450_a, p.field_72448_b + 0.25, p.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    };


    public static void sendToClients(Entity source, ParticlePacketData data) {
        if (source.field_70170_p.field_72995_K) {
            try {
                data.type.activate(data, source.field_70170_p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            MMORPG.sendToTracking(new ParticlePacket(data), source);
        }
    }

    public static void sendToClients(BlockPos pos, World world, ParticlePacketData data) {
        if (!world.field_72995_K) {
            MMORPG.sendToTracking(new ParticlePacket(data), pos, world);
        } else {
            data.type.activate(data, world);
        }
    }

    public Vec3d getCenter(ParticlePacketData data) {
        if (data.isVecPos) {
            return data.getPos();
        }
        BlockPos pos = data.getBlockPos();
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public void spawnRedstone(World world, RGB color, double xpos, double ypos, double zpos) {
        RedstoneParticleData data = new RedstoneParticleData(color.getR(), color.getG(), color.getB(), 1.0f);
        world.func_195590_a((IParticleData)data, true, xpos, ypos, zpos, 1.0, 1.0, 1.0);
    }

    public abstract void activate(ParticlePacketData var1, World var2);
}

