/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets.spells;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class CastSpellPacket {
    public Integer hotbarNumber;
    public SpellCastingData.Hotbar hotbar;

    public CastSpellPacket() {
    }

    public CastSpellPacket(Integer hotbarNumber, SpellCastingData.Hotbar bar) {
        this.hotbarNumber = hotbarNumber;
        this.hotbar = bar;
    }

    public static CastSpellPacket decode(PacketBuffer buf) {
        CastSpellPacket newpkt = new CastSpellPacket();
        newpkt.hotbarNumber = buf.readInt();
        newpkt.hotbar = SpellCastingData.Hotbar.valueOf(buf.func_150789_c(30));
        return newpkt;
    }

    public static void encode(CastSpellPacket packet, PacketBuffer tag) {
        tag.writeInt(packet.hotbarNumber.intValue());
        tag.func_180714_a(packet.hotbar.name());
    }

    public static void handle(CastSpellPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                PlayerSpellCap.ISpellsCap spells = Load.spells((LivingEntity)player);
                if (spells.getCastingData().canCast(pkt.hotbarNumber, pkt.hotbar, (PlayerEntity)player)) {
                    spells.getCastingData().setToCast(pkt.hotbarNumber, pkt.hotbar, (PlayerEntity)player, 0);
                    BaseSpell spell = spells.getCastingData().getSpellBeingCast();
                    if (spell != null) {
                        SpellCastContext c = new SpellCastContext((LivingEntity)player, 0, spell);
                        spell.spendResources(c);
                    }
                    spells.syncToClient((PlayerEntity)player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

