/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets.spells;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.packets.sync_cap.SyncCapabilityToClient;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class HotbarSetupPacket {
    public int number;
    public SpellCastingData.Hotbar hotbar;
    public String spellID = "";

    private HotbarSetupPacket() {
    }

    public HotbarSetupPacket(BaseSpell spell, int num, SpellCastingData.Hotbar bar) {
        this.number = num;
        this.hotbar = bar;
        if (spell != null) {
            this.spellID = spell.GUID();
        }
    }

    public static HotbarSetupPacket decode(PacketBuffer buf) {
        HotbarSetupPacket newpkt = new HotbarSetupPacket();
        newpkt.number = buf.readInt();
        newpkt.hotbar = SpellCastingData.Hotbar.valueOf(buf.func_150789_c(30));
        newpkt.spellID = buf.func_150789_c(30);
        return newpkt;
    }

    public static void encode(HotbarSetupPacket packet, PacketBuffer tag) {
        tag.writeInt(packet.number);
        tag.func_180714_a(packet.hotbar.name());
        tag.func_180714_a(packet.spellID);
    }

    public static void handle(HotbarSetupPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                SpellCastingData data = Load.spells((LivingEntity)player).getCastingData();
                data.setHotbar(pkt.number, pkt.hotbar, pkt.spellID);
                MMORPG.sendToClient(new SyncCapabilityToClient(player, PlayerCaps.SPELLS), player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

