/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.packets.trader;

import com.robertx22.mine_and_slash.new_content.trader.TraderData;
import com.robertx22.mine_and_slash.new_content.trader.TraderEntity;
import com.robertx22.mine_and_slash.uncommon.datasaving.TraderSaving;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class TraderPacket {
    public TraderData data;
    public int traderID;

    public TraderPacket() {
    }

    public TraderPacket(TraderData data, TraderEntity en) {
        this.data = data;
        this.traderID = en.func_145782_y();
    }

    public static TraderPacket decode(PacketBuffer buf) {
        TraderPacket newpkt = new TraderPacket();
        newpkt.data = TraderSaving.Load(buf.func_150793_b());
        newpkt.traderID = buf.readInt();
        return newpkt;
    }

    public static void encode(TraderPacket packet, PacketBuffer tag) {
        CompoundNBT nbt = new CompoundNBT();
        TraderSaving.Save(nbt, packet.data);
        tag.func_150786_a(nbt);
        tag.writeInt(packet.traderID);
    }

    public static void handle(TraderPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ClientOnly.openOrUpdateTradeGui(pkt.data, pkt.traderID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

