/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.all;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.ScalingStatCalc;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class BleedPotion
extends BasePotionEffect {
    public static final BleedPotion INSTANCE = new BleedPotion();
    public static ScalingStatCalc CALC = new ScalingStatCalc(PhysicalDamage.getInstance(), 0.15f);

    private BleedPotion() {
        super(EffectType.HARMFUL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.tickActions.add(new OnTickAction(ctx -> {
            int num = CALC.getCalculatedValue(ctx.casterData);
            if (ctx.entity.field_70170_p.field_72995_K) {
                ParticleUtils.spawnParticles((ParticleType)ParticleTypes.field_197595_F, ctx.entity, 15);
            } else {
                DamageEffect dmg = new DamageEffect(null, ctx.caster, ctx.entity, num, ctx.casterData, ctx.entityData, EffectData.EffectTypes.DOT_DMG, WeaponTypes.None);
                dmg.removeKnockback();
                dmg.Activate();
            }
            return ctx;
        }, null));
    }

    @Override
    public String GUID() {
        return "bleed";
    }

    @Override
    public String locNameForLangFile() {
        return "Bleed";
    }

    @Override
    public List<ITextComponent> getEffectTooltip(TooltipInfo info) {
        return new ArrayList<ITextComponent>();
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.TICK_RATE, 20.0f, 20.0f);
        p.set(SC.DURATION_TICKS, 60.0f, 60.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return null;
    }

    @Override
    public Masteries getMastery() {
        return null;
    }
}

