/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.bases;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionContext;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionDataSaving;
import com.robertx22.mine_and_slash.potion_effects.bases.data.ExtraPotionData;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.SpellCalcData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BasePotionEffect
extends Effect
implements ISlashRegistryEntry<BasePotionEffect>,
IAutoLocName,
ITooltipList,
IAbility {
    protected List<OnTickAction> tickActions = new ArrayList<OnTickAction>();

    public PreCalcSpellConfigs getConfig(LivingEntity caster) {
        return this.getCtx(caster).getConfigFor(this.getAbilityThatDeterminesLevel());
    }

    public SpellCalcData getCalc(LivingEntity caster) {
        return this.getConfig(caster).getCalc(Load.spells(caster), this.getAbilityThatDeterminesLevel());
    }

    public SpellCastContext getCtx(LivingEntity caster) {
        return new SpellCastContext(caster, 0, this.getAbilityThatDeterminesLevel());
    }

    @Override
    public ITextComponent getLocName() {
        return this.locName();
    }

    @Override
    public ResourceLocation getIconLoc() {
        return this.getIconTexture();
    }

    @Override
    public IAbility.Type getAbilityType() {
        return IAbility.Type.EFFECT;
    }

    @Override
    public Elements getElement() {
        if (this.getSpell() != null) {
            return this.getSpell().getElement();
        }
        return Elements.Physical;
    }

    @Override
    public SlashRegistryType getSlashRegistryType() {
        return SlashRegistryType.EFFECT;
    }

    @Override
    public int getMaxSpellLevelNormal() {
        return 8;
    }

    @Override
    public int getMaxSpellLevelBuffed() {
        return this.getMaxSpellLevelNormal() + 5;
    }

    @Override
    public AbilityPlace getAbilityPlace() {
        return null;
    }

    public IAbility getAbilityThatDeterminesLevel() {
        if (this.getSpell() != null) {
            return this.getSpell();
        }
        return this;
    }

    @Override
    public IAbility getRequiredAbility() {
        return null;
    }

    public int getMaxStacks() {
        return 1;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Potions;
    }

    @Override
    public String locNameLangFileGUID() {
        return this.getRegistryName().toString();
    }

    @Override
    public abstract String GUID();

    @Override
    public ITextComponent locName() {
        return CLOC.blank("effect.mmorpg." + this.GUID());
    }

    public List<ITextComponent> getEffectTooltip(TooltipInfo info) {
        return new ArrayList<ITextComponent>();
    }

    @Override
    public final List<ITextComponent> GetTooltipString(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(new StringTextComponent(TextFormatting.LIGHT_PURPLE + "" + TextFormatting.BOLD).func_150257_a(this.locName()));
        list.addAll(this.getEffectTooltip(info));
        if (this instanceof IApplyStatPotion) {
            list.addAll(((IApplyStatPotion)((Object)this)).getStatTooltip(info, this));
        }
        list.add((ITextComponent)new SText(""));
        this.tickActions.forEach(x -> list.addAll(x.getTooltip(info, this)));
        list.addAll(this.getMaxStacksTooltip());
        list.addAll(this.getDurationTooltip(info));
        if (info.showAbilityExtraInfo) {
            this.finishTooltip(list, new SpellCastContext((LivingEntity)info.player, 0, this), info);
        }
        return list;
    }

    public ResourceLocation getIconTexture() {
        return new ResourceLocation("mmorpg", "textures/mob_effect/" + this.GUID() + ".png");
    }

    private List<ITextComponent> getMaxStacksTooltip() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        TooltipUtils.addEmpty(list);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.LIGHT_PURPLE + "Max Stacks: " + TextFormatting.DARK_PURPLE + this.getMaxStacks()));
        return list;
    }

    private List<ITextComponent> getDurationTooltip(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        TooltipUtils.addEmpty(list);
        list.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Duration: " + TextFormatting.YELLOW + this.getDurationInSeconds((LivingEntity)info.player) + "s"));
        return list;
    }

    public final int getDurationInSeconds(LivingEntity en) {
        return this.getDurationInTicks(en) / 20;
    }

    public final int getDurationInTicks(LivingEntity en) {
        IAbility ability = this.getAbilityThatDeterminesLevel();
        return (int)new SpellCastContext(en, 0, ability).getConfigFor(ability).get(SC.DURATION_TICKS).get(Load.spells(en), ability);
    }

    public int getTickRate(LivingEntity en) {
        IAbility ability = this.getAbilityThatDeterminesLevel();
        return (int)new SpellCastContext(en, 0, ability).getConfigFor(ability).get(SC.TICK_RATE).get(Load.spells(en), ability);
    }

    public void func_76394_a(LivingEntity en, int amplifier) {
        try {
            int tickrate;
            boolean delete = false;
            if (this.tickActions.size() > 0 && en.field_70173_aa % (tickrate = this.getTickRate(en)) == 0) {
                for (OnTickAction x : this.tickActions) {
                    EffectInstance instance = en.func_70660_b((Effect)this);
                    if (instance == null) {
                        delete = true;
                        return;
                    }
                    ExtraPotionData data = PotionDataSaving.getData(instance);
                    if (data == null) {
                        delete = true;
                        return;
                    }
                    LivingEntity caster = data.getCaster(en.field_70170_p);
                    if (caster == null) {
                        delete = true;
                        return;
                    }
                    x.onTick(new PotionContext(en, data, caster));
                }
            }
            if (delete) {
                en.func_195063_d((Effect)this);
            }
        }
        catch (Exception e) {
            en.func_195063_d((Effect)this);
            e.printStackTrace();
        }
    }

    protected BasePotionEffect(EffectType type, int liquidColorIn) {
        super(type, liquidColorIn);
    }

    public EffectInstance getInstanceFromEntity(LivingEntity entity) {
        return entity.func_70660_b((Effect)this);
    }

    protected boolean isServerSideOnly() {
        return true;
    }

    public boolean func_76397_a(int duration, int amplitude) {
        return duration >= 1;
    }

    public boolean func_76403_b() {
        return true;
    }

    public void func_180793_a(Entity applier, Entity caster, @Nonnull LivingEntity target, int amplifier, double health) {
        if (target.field_70170_p.field_72995_K && this.isServerSideOnly()) {
            return;
        }
        this.onEffectApplied(applier, caster, target, amplifier);
    }

    public void func_111185_a(LivingEntity target, @Nonnull AbstractAttributeMap attributes, int amplifier) {
        if (!target.field_70170_p.field_72995_K || !this.isServerSideOnly()) {
            this.onPotionAdd(target);
        }
        super.func_111185_a(target, attributes, amplifier);
    }

    public void func_111187_a(LivingEntity target, @Nonnull AbstractAttributeMap attributes, int amplifier) {
        super.func_111187_a(target, attributes, amplifier);
        this.onPotionRemove(target);
    }

    public void onPotionAdd(LivingEntity target) {
    }

    public void onPotionRemove(LivingEntity target) {
    }

    public void onEffectApplied(Entity applier, Entity caster, LivingEntity target, int amplifier) {
    }

    protected boolean shouldShowParticles() {
        return false;
    }

    protected boolean isAmbient() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(EffectInstance effect, AbstractGui gui, int x, int y, float z, float alpha) {
        if (this.getIconTexture() != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getIconTexture());
            AbstractGui.blit((int)(x + 4), (int)(y + 4), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }
}

