/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.bases;

import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionDataSaving;
import com.robertx22.mine_and_slash.potion_effects.bases.data.ExtraPotionData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PotionEffectUtils {
    public static void reApplyToSelf(BasePotionEffect effect, LivingEntity caster) {
        PotionEffectUtils.apply(effect, caster, caster);
    }

    public static void applyToSelf(BasePotionEffect effect, LivingEntity caster) {
        PotionEffectUtils.apply(effect, caster, caster);
    }

    public static void apply(BasePotionEffect effect, LivingEntity caster, LivingEntity target) {
        if (caster.field_70170_p.field_72995_K) {
            return;
        }
        int duration = effect.getDurationInTicks(caster);
        EntityCap.UnitData casterData = Load.Unit((ICapabilityProvider)caster);
        EffectInstance instance = target.func_70660_b((Effect)effect);
        ExtraPotionData extraData = instance != null ? PotionDataSaving.getData(instance) : new ExtraPotionData();
        if (extraData == null) {
            extraData = new ExtraPotionData();
        }
        if (extraData.getInitialDurationTicks() > 0) {
            duration = extraData.getInitialDurationTicks();
        }
        EffectInstance newInstance = new EffectInstance((Effect)effect, duration, extraData.getStacks(), false, false, true);
        if (instance == null) {
            extraData.casterLvl = casterData.getLevel();
            extraData.casterID = caster.func_110124_au().toString();
            extraData.setInitialDurationTicks(duration);
            PotionDataSaving.saveData(newInstance, extraData);
            target.func_195064_c(newInstance);
        } else {
            if (instance.func_76459_b() > duration) {
                duration = instance.func_76459_b();
            }
            extraData.casterLvl = casterData.getLevel();
            extraData.casterID = caster.func_110124_au().toString();
            extraData.setInitialDurationTicks(duration);
            extraData.addStacks(1, effect);
            PotionDataSaving.saveData(newInstance, extraData);
            target.func_195063_d((Effect)effect);
            target.func_195064_c(newInstance);
        }
    }

    public static boolean reduceStacks(LivingEntity target, BasePotionEffect effect) {
        return PotionEffectUtils.reduceStacks(target, effect, 1);
    }

    public static boolean has(LivingEntity entity, BasePotionEffect effect) {
        return entity.func_70660_b((Effect)effect) != null;
    }

    public static boolean reduceStacks(LivingEntity target, BasePotionEffect effect, int num) {
        EffectInstance instance = target.func_70660_b((Effect)effect);
        if (instance != null) {
            ExtraPotionData extraData = PotionDataSaving.getData(instance);
            extraData.decreaseStacks(num, effect);
            if (extraData.getStacks() <= 0) {
                target.func_195063_d((Effect)effect);
            } else {
                PotionDataSaving.saveData(instance, extraData);
            }
            return true;
        }
        return false;
    }

    public static int getStacks(LivingEntity en, BasePotionEffect effect) {
        ExtraPotionData extraData;
        EffectInstance instance = en.func_70660_b((Effect)effect);
        if (instance != null && (extraData = PotionDataSaving.getData(instance)) != null) {
            return extraData.getStacks();
        }
        return 0;
    }
}

