/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.divine;

import com.robertx22.mine_and_slash.database.spells.SpellUtils;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.divine.SpearOfJudgementSpell;
import com.robertx22.mine_and_slash.database.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.IOnBasicAttackedPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionDataSaving;
import com.robertx22.mine_and_slash.potion_effects.bases.PotionEffectUtils;
import com.robertx22.mine_and_slash.potion_effects.bases.data.ExtraPotionData;
import com.robertx22.mine_and_slash.potion_effects.bases.data.PotionStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class JudgementEffect
extends BasePotionEffect
implements IApplyStatPotion,
IOnBasicAttackedPotion {
    public static final JudgementEffect INSTANCE = new JudgementEffect();

    private JudgementEffect() {
        super(EffectType.HARMFUL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.tickActions.add(new OnTickAction(ctx -> {
            ParticleUtils.spawnParticles((ParticleType)ParticleTypes.field_229428_ah_, ctx.entity, 25);
            return ctx;
        }, null));
    }

    @Override
    public String GUID() {
        return "judgement";
    }

    @Override
    public String locNameForLangFile() {
        return "Judgment";
    }

    @Override
    public int getMaxStacks() {
        return 5;
    }

    @Override
    public List<PotionStat> getPotionStats() {
        ArrayList<PotionStat> list = new ArrayList<PotionStat>();
        list.add(new PotionStat(-3.0f, new ElementalResist(Elements.Elemental)));
        list.add(new PotionStat(-12.0f, Armor.getInstance()));
        return list;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.DURATION_TICKS, 100.0f, 120.0f);
        p.set(SC.TICK_RATE, 20.0f, 20.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return SpearOfJudgementSpell.getInstance();
    }

    @Override
    public Masteries getMastery() {
        return this.getSpell().getMastery();
    }

    @Override
    public List<ITextComponent> getEffectTooltip(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Attack to add additional stacks. At max"));
        list.add((ITextComponent)new StringTextComponent("stacks, consume to deal extra damage: "));
        return list;
    }

    @Override
    public void onBasicAttacked(EffectInstance instance, LivingEntity source, LivingEntity target) {
        ExtraPotionData data = PotionDataSaving.getData(instance);
        LivingEntity caster = data.getCaster(source.field_70170_p);
        if (data.getStacks() < this.getMaxStacks()) {
            PotionEffectUtils.apply(this, caster, target);
        } else {
            SpellUtils.summonLightningStrike((Entity)target);
            SoundUtils.playSound((Entity)target, SoundEvents.field_187752_dd, 1.0f, 1.0f);
            int num = this.getCalc(source).getCalculatedValue(Load.Unit((ICapabilityProvider)caster), Load.spells(caster), this.getSpell());
            SpellDamageEffect dmg = new SpellDamageEffect(caster, target, num, Load.Unit((ICapabilityProvider)caster), Load.Unit((ICapabilityProvider)target), this.getSpell());
            dmg.element = Elements.Thunder;
            dmg.Activate();
            target.func_195063_d((Effect)this);
        }
    }
}

