/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.druid;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.nature.ThoughtSeizeSpell;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShieldRegen;
import com.robertx22.mine_and_slash.database.stats.types.resources.ManaRegen;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.IOneOfATypePotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.potion_effects.bases.data.PotionStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;

public class MindRotEffect
extends BasePotionEffect
implements IApplyStatPotion,
IOneOfATypePotion {
    public static final MindRotEffect INSTANCE = new MindRotEffect();

    @Override
    public IOneOfATypePotion.Type getOneOfATypeType() {
        return IOneOfATypePotion.Type.NATURE_CURSE;
    }

    private MindRotEffect() {
        super(EffectType.HARMFUL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.tickActions.add(new OnTickAction(ctx -> {
            ParticleEnum.sendToClients((Entity)ctx.entity, new ParticlePacketData(ctx.entity.func_180425_c(), ParticleEnum.AOE).type((ParticleType)ParticleTypes.field_197607_R).motion(new Vec3d(0.0, 0.0, 0.0)).amount(15));
            return ctx;
        }, null));
    }

    @Override
    public String GUID() {
        return "mind_rot";
    }

    @Override
    public String locNameForLangFile() {
        return "Mind Rot";
    }

    @Override
    public Elements getElement() {
        return Elements.Nature;
    }

    @Override
    public int getMaxStacks() {
        return 1;
    }

    @Override
    public List<PotionStat> getPotionStats() {
        ArrayList<PotionStat> list = new ArrayList<PotionStat>();
        list.add(new PotionStat(-20.0f, MagicShieldRegen.getInstance()));
        list.add(new PotionStat(-5.0f, ManaRegen.getInstance()));
        list.add(new PotionStat(-10.0f, new ElementalResist(Elements.Elemental)));
        return list;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.TICK_RATE, 40.0f, 40.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return ThoughtSeizeSpell.getInstance();
    }

    @Override
    public Masteries getMastery() {
        return this.getSpell().getMastery();
    }

    @Override
    public List<ITextComponent> getEffectTooltip(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        return list;
    }
}

