/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.druid;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.nature.GorgonsGazeSpell;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.IOnBasicAttackedPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class PetrifyEffect
extends BasePotionEffect
implements IOnBasicAttackedPotion {
    public static final PetrifyEffect INSTANCE = new PetrifyEffect();

    private PetrifyEffect() {
        super(EffectType.HARMFUL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.func_220304_a(SharedMonsterAttributes.field_111263_d, "7107DE5E-7CE8-4030-940E-514C1F160892", -0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.tickActions.add(new OnTickAction(ctx -> {
            ParticleEnum.sendToClients((Entity)ctx.entity, new ParticlePacketData(ctx.entity.func_180425_c(), ParticleEnum.PETRIFY).radius(1.0f).type((ParticleType)ParticleTypes.field_197613_f).amount(25));
            SoundUtils.playSound((Entity)ctx.entity, SoundEvents.field_187835_fT, 0.5f, 0.5f);
            return ctx;
        }, null));
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.BASE_VALUE, 1.0f, 5.0f);
        p.set(SC.TICK_RATE, 20.0f, 20.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return GorgonsGazeSpell.getInstance();
    }

    @Override
    public Masteries getMastery() {
        return Masteries.NATURE;
    }

    @Override
    public String GUID() {
        return "petrify";
    }

    @Override
    public String locNameForLangFile() {
        return "Petrify";
    }

    @Override
    public int getMaxStacks() {
        return 1;
    }

    @Override
    public List<ITextComponent> getEffectTooltip(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Petrifies the enemy, preventing movement."));
        list.add((ITextComponent)new StringTextComponent("Next attack does extra damage but stops effect: "));
        list.addAll(this.getCalc((LivingEntity)info.player).GetTooltipString(info, Load.spells((LivingEntity)info.player), this));
        return list;
    }

    @Override
    public void onBasicAttacked(EffectInstance instance, LivingEntity source, LivingEntity target) {
        int num = this.getCalc(source).getCalculatedValue(Load.Unit((ICapabilityProvider)source), Load.spells(source), this);
        DamageEffect dmg = new DamageEffect(null, source, target, num, EffectData.EffectTypes.SPELL, WeaponTypes.None);
        dmg.element = Elements.Nature;
        dmg.Activate();
        ParticleEnum.sendToClients((Entity)target, new ParticlePacketData(target.func_180425_c(), ParticleEnum.PETRIFY).radius(1.0f).type((ParticleType)ParticleTypes.field_197613_f).amount(20));
        target.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f);
        target.func_195063_d((Effect)this);
    }
}

