/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.druid;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.nature.NatureBalmSpell;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;

public class RegenerateEffect
extends BasePotionEffect {
    public static final RegenerateEffect INSTANCE = new RegenerateEffect();

    private RegenerateEffect() {
        super(EffectType.BENEFICIAL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.tickActions.add(new OnTickAction(ctx -> {
            if (ctx.entity.field_70170_p.field_72995_K) {
                ParticleUtils.spawnParticles((ParticleType)ParticleTypes.field_197632_y, ctx.entity, 5);
            } else {
                int num = this.getCalc(ctx.caster).getCalculatedValue(ctx.casterData, ctx.spellsCap, this.getAbilityThatDeterminesLevel());
                ResourcesData.Context hp = new ResourcesData.Context(ctx.caster, ctx.entity, ctx.casterData, ctx.entityData, ResourcesData.Type.HEALTH, num, ResourcesData.Use.RESTORE, NatureBalmSpell.getInstance());
                ctx.entityData.modifyResource(hp);
            }
            return ctx;
        }, info -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new StringTextComponent("Heals user:"));
            list.addAll(this.getCalc((LivingEntity)info.player).GetTooltipString((TooltipInfo)info, Load.spells((LivingEntity)info.player), this.getAbilityThatDeterminesLevel()));
            return list;
        }));
    }

    @Override
    public String GUID() {
        return "self_regen";
    }

    @Override
    public String locNameForLangFile() {
        return "Regenerate";
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return NatureBalmSpell.getInstance();
    }

    @Override
    public Masteries getMastery() {
        if (this.getSpell() != null) {
            return this.getSpell().getMastery();
        }
        return null;
    }
}

