/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.druid;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.spells.spell_classes.nature.RootSpell;
import com.robertx22.mine_and_slash.database.stats.types.resources.EnergyRegen;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.potion_effects.bases.data.PotionStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class RootEffect
extends BasePotionEffect
implements IApplyStatPotion {
    public static final RootEffect INSTANCE = new RootEffect();

    private RootEffect() {
        super(EffectType.BENEFICIAL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.func_220304_a(SharedMonsterAttributes.field_188790_f, "7107DE5E-7CE8-4030-940E-514C1F160892", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.tickActions.add(new OnTickAction(ctx -> {
            ParticleEnum.sendToClients((Entity)ctx.entity, new ParticlePacketData(ctx.entity.func_180425_c(), ParticleEnum.THORNS).radius(1.0f).type((ParticleType)ParticleTypes.field_197613_f).amount(25));
            SoundUtils.playSound((Entity)ctx.entity, SoundEvents.field_187571_bR, 0.5f, 1.0f);
            return ctx;
        }, null));
    }

    @Override
    public String GUID() {
        return "root";
    }

    @Override
    public String locNameForLangFile() {
        return "Natural Empowering";
    }

    @Override
    public int getMaxStacks() {
        return 1;
    }

    @Override
    public List<PotionStat> getPotionStats() {
        ArrayList<PotionStat> list = new ArrayList<PotionStat>();
        list.add(new PotionStat(30.0f, EnergyRegen.getInstance()));
        return list;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.TICK_RATE, 20.0f, 20.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return RootSpell.getInstance();
    }

    @Override
    public Masteries getMastery() {
        return this.getSpell().getMastery();
    }

    @Override
    public List<ITextComponent> getEffectTooltip(TooltipInfo info) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new StringTextComponent("Increases base weapon attack speed by 25%."));
        return list;
    }
}

