/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.druid;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.stats.types.resources.HealPower;
import com.robertx22.mine_and_slash.database.stats.types.resources.HealthRegen;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.potion_effects.bases.data.PotionStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.StringTextComponent;

public class ThornsEffect
extends BasePotionEffect
implements IApplyStatPotion {
    public static final ThornsEffect INSTANCE = new ThornsEffect();

    private ThornsEffect() {
        super(EffectType.HARMFUL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.tickActions.add(new OnTickAction(ctx -> {
            int num = this.getCalc(ctx.caster).getCalculatedValue(ctx.casterData, ctx.spellsCap, this);
            DamageEffect dmg = new DamageEffect(null, ctx.caster, ctx.entity, num, ctx.casterData, ctx.entityData, EffectData.EffectTypes.SPELL, WeaponTypes.None);
            dmg.element = Elements.Nature;
            dmg.removeKnockback();
            dmg.Activate();
            ParticleEnum.sendToClients((Entity)ctx.entity, new ParticlePacketData(ctx.entity.func_180425_c(), ParticleEnum.THORNS).amount(15));
            SoundUtils.playSound((Entity)ctx.entity, SoundEvents.field_187571_bR, 1.0f, 1.0f);
            return ctx;
        }, info -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new StringTextComponent("Does damage:"));
            list.addAll(this.getCalc((LivingEntity)info.player).GetTooltipString((TooltipInfo)info, Load.spells((LivingEntity)info.player), this));
            return list;
        }));
    }

    @Override
    public String GUID() {
        return "thorns";
    }

    @Override
    public String locNameForLangFile() {
        return "Thorns";
    }

    @Override
    public Elements getElement() {
        return Elements.Nature;
    }

    @Override
    public int getMaxStacks() {
        return 1;
    }

    @Override
    public List<PotionStat> getPotionStats() {
        ArrayList<PotionStat> list = new ArrayList<PotionStat>();
        list.add(new PotionStat(-10.0f, HealPower.getInstance()));
        list.add(new PotionStat(-10.0f, HealthRegen.getInstance()));
        return list;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.BASE_VALUE, 1.0f, 1.5f);
        p.set(SC.NATURE_ATTACK_SCALE_VALUE, 0.3f, 0.6f);
        p.set(SC.TICK_RATE, 40.0f, 30.0f);
        p.set(SC.DURATION_TICKS, 200.0f, 600.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return null;
    }

    @Override
    public Masteries getMastery() {
        return Masteries.NATURE;
    }
}

