/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.ember_mage;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.potion_effects.bases.data.PotionStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.StringTextComponent;

public class BurnEffect
extends BasePotionEffect
implements IApplyStatPotion {
    public static final BurnEffect INSTANCE = new BurnEffect();

    private BurnEffect() {
        super(EffectType.HARMFUL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.tickActions.add(new OnTickAction(ctx -> {
            int num = this.getCalc(ctx.caster).getCalculatedValue(ctx.casterData, ctx.spellsCap, this);
            DamageEffect dmg = new DamageEffect(null, ctx.caster, ctx.entity, num, ctx.casterData, ctx.entityData, EffectData.EffectTypes.SPELL, WeaponTypes.None);
            dmg.element = Elements.Fire;
            dmg.removeKnockback();
            dmg.Activate();
            SoundUtils.playSound((Entity)ctx.entity, SoundEvents.field_219605_aC, 0.5f, 1.0f);
            ParticleEnum.sendToClients((Entity)ctx.entity, new ParticlePacketData(ctx.entity.func_180425_c(), ParticleEnum.AOE).type((ParticleType)ParticleTypes.field_197631_x).motion(new Vec3d(0.0, 0.0, 0.0)).amount(15));
            return ctx;
        }, info -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new StringTextComponent("Does damage:"));
            list.addAll(this.getCalc((LivingEntity)info.player).GetTooltipString((TooltipInfo)info, Load.spells((LivingEntity)info.player), this.getAbilityThatDeterminesLevel()));
            return list;
        }));
    }

    @Override
    public String GUID() {
        return "burn";
    }

    @Override
    public Elements getElement() {
        return Elements.Fire;
    }

    @Override
    public String locNameForLangFile() {
        return "Burn";
    }

    @Override
    public int getMaxStacks() {
        return 1;
    }

    @Override
    public List<PotionStat> getPotionStats() {
        ArrayList<PotionStat> list = new ArrayList<PotionStat>();
        list.add(new PotionStat(-5.0f, new ElementalResist(Elements.Elemental)));
        return list;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.BASE_VALUE, 2.0f, 5.5f);
        p.set(SC.DURATION_TICKS, 60.0f, 120.0f);
        p.set(SC.TICK_RATE, 30.0f, 15.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return null;
    }

    @Override
    public Masteries getMastery() {
        return Masteries.FIRE;
    }
}

