/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.potion_effects.ranger;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.database.stats.types.resources.HealPower;
import com.robertx22.mine_and_slash.packets.particles.ParticleEnum;
import com.robertx22.mine_and_slash.packets.particles.ParticlePacketData;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.OnTickAction;
import com.robertx22.mine_and_slash.potion_effects.bases.data.PotionStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.StringTextComponent;

public class WoundsEffect
extends BasePotionEffect
implements IApplyStatPotion {
    private WoundsEffect() {
        super(EffectType.HARMFUL, 4393423);
        this.setRegistryName(new ResourceLocation("mmorpg", this.GUID()));
        this.func_220304_a(SharedMonsterAttributes.field_111263_d, "7107DE5E-7CE8-4030-940E-514C1F160895", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.tickActions.add(new OnTickAction(ctx -> {
            int num = this.getCalc(ctx.caster).getCalculatedValue(ctx.casterData, ctx.spellsCap, this);
            DamageEffect dmg = new DamageEffect(null, ctx.caster, ctx.entity, num, ctx.casterData, ctx.entityData, EffectData.EffectTypes.SPELL, WeaponTypes.None);
            dmg.element = Elements.Elemental;
            dmg.removeKnockback();
            dmg.Activate();
            ParticleEnum.sendToClients((Entity)ctx.entity, new ParticlePacketData(ctx.entity.func_180425_c(), ParticleEnum.AOE).type(ParticleTypes.field_197619_l).motion(new Vec3d(0.0, 0.0, 0.0)).amount(15));
            return ctx;
        }, info -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new StringTextComponent("Does damage:"));
            list.addAll(this.getCalc((LivingEntity)info.player).GetTooltipString((TooltipInfo)info, Load.spells((LivingEntity)info.player), this));
            return list;
        }));
    }

    public static WoundsEffect getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String GUID() {
        return "wounds";
    }

    @Override
    public String locNameForLangFile() {
        return "Wounds";
    }

    @Override
    public Elements getElement() {
        return Elements.Elemental;
    }

    @Override
    public int getMaxStacks() {
        return 1;
    }

    @Override
    public List<PotionStat> getPotionStats() {
        ArrayList<PotionStat> list = new ArrayList<PotionStat>();
        list.add(new PotionStat(-50.0f, HealPower.getInstance()));
        return list;
    }

    @Override
    public PreCalcSpellConfigs getPreCalcConfig() {
        PreCalcSpellConfigs p = new PreCalcSpellConfigs();
        p.set(SC.BASE_VALUE, 3.0f, 5.0f);
        p.set(SC.TICK_RATE, 30.0f, 20.0f);
        p.set(SC.DURATION_TICKS, 900.0f, 1500.0f);
        return p;
    }

    @Override
    @Nullable
    public BaseSpell getSpell() {
        return null;
    }

    @Override
    public Masteries getMastery() {
        return Masteries.HUNTING;
    }

    private static class SingletonHolder {
        private static final WoundsEffect INSTANCE = new WoundsEffect();

        private SingletonHolder() {
        }
    }
}

