/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.registry;

import com.robertx22.mine_and_slash.database.affixes.BaseAffix;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.db_lists.bases.IhasRequirements;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.comparators.RarityComparator;
import com.robertx22.mine_and_slash.uncommon.datasaving.ItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IGearSlotType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FilterListWrap<C extends ISlashRegistryEntry> {
    private boolean errorIfNothingLeft = true;
    public List<C> list = new ArrayList<C>();

    public FilterListWrap(List<C> list) {
        this.list = list;
    }

    public FilterListWrap(Collection<C> list) {
        this.list = new ArrayList<C>(list);
    }

    public FilterListWrap<C> errorIfNothingLeft(boolean bool) {
        this.errorIfNothingLeft = bool;
        return this;
    }

    public FilterListWrap<C> ofAffixType(BaseAffix.Type type) {
        this.list = this.list.stream().filter(x -> ((BaseAffix)x).type.equals((Object)type)).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofTierOrLess(int tier) {
        this.list = this.list.stream().filter(x -> x.getTier() <= tier).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> of(Predicate<C> pred) {
        this.list = this.list.stream().filter(pred).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofCurrencyUsableOnItemType(ItemType type) {
        this.list = this.list.stream().filter(x -> ((CurrencyItem)x).itemTypesUsableOn == type).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofTierRange(int min, int max) {
        this.list = this.list.stream().filter(x -> x.getTier() >= min && x.getTier() <= max).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofExactTier(int tier) {
        this.list = this.list.stream().filter(x -> x.getTier() == tier).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofExactRarity(int rarity) {
        this.list = this.list.stream().filter(x -> x.getRarityRank() == rarity).collect(Collectors.toList());
        return this;
    }

    public FilterListWrap<C> ofHighestRarity() {
        Optional<IRarity> optional = this.list.stream().max(new RarityComparator());
        if (optional.isPresent()) {
            int highest = ((ISlashRegistryEntry)optional.get()).getRarityRank();
            this.list = this.list.stream().filter(x -> x.getRarityRank() == highest).collect(Collectors.toList());
        } else {
            this.list.clear();
        }
        return this;
    }

    public FilterListWrap<C> ofSpecificGearType(String type) {
        if (!type.isEmpty() && !type.equals("random")) {
            this.list = this.list.stream().filter(x -> ((IGearSlotType)((Object)x)).getGearSlot().GUID().equals(type)).collect(Collectors.toList());
        }
        return this;
    }

    public FilterListWrap<C> randomAmount(int amount) {
        ArrayList<C> list = new ArrayList<C>();
        for (int tries = 0; list.size() < amount && tries < 20; ++tries) {
            list.add(this.random());
        }
        this.list = list;
        return this;
    }

    public FilterListWrap<C> allThatMeetRequirement(GearItemData gear) {
        return this.allThatMeetRequirement(new GearRequestedFor(gear));
    }

    public FilterListWrap<C> allThatMeetRequirement(GearRequestedFor request) {
        this.list = this.list.stream().filter(x -> ((IhasRequirements)((Object)x)).meetsRequirements(request)).collect(Collectors.toList());
        return this;
    }

    public C random() {
        if (this.list.isEmpty()) {
            if (this.errorIfNothingLeft) {
                try {
                    throw new Exception("Items filtered too much, no possibility left, returning null!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MMORPG.devToolsLog("Items filtered too much, no possibility left, returning null!");
                }
            }
            return null;
        }
        return (C)((ISlashRegistryEntry)RandomUtils.weightedRandom(this.list));
    }
}

