/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.registry;

import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.IRarity;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ITiered;
import java.util.List;

public interface ISlashRegistryEntry<C>
extends IGUID,
IWeighted,
ITiered,
IRarity {
    public SlashRegistryType getSlashRegistryType();

    default public C getFromRegistry() {
        return (C)SlashRegistry.get(this.getSlashRegistryType(), this.GUID());
    }

    default public void registerToSlashRegistry() {
        SlashRegistry.getRegistry(this.getSlashRegistryType()).register(this);
    }

    default public void unregisterFromSlashRegistry() {
        SlashRegistry.getRegistry(this.getSlashRegistryType()).unRegister(this);
    }

    @Override
    default public boolean isUnique() {
        return this.getRarityRank() == -1;
    }

    default public void unregisterDueToInvalidity() {
        SlashRegistry.getRegistry(this.getSlashRegistryType()).unRegister(this);
        try {
            throw new Exception("Registry Entry: " + this.GUID() + " is invalid! Unregistering");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    default public boolean isFromDatapack() {
        return false;
    }

    default public boolean unregisterBeforeConfigsLoad() {
        return false;
    }

    @Override
    default public int Weight() {
        return this.getRarity().Weight();
    }

    default public boolean isRegistryEntryValid() {
        return true;
    }

    default public boolean checkStatModsValidity(List<StatMod> mods) {
        return !mods.stream().anyMatch(x -> {
            if (!SlashRegistry.StatMods().isRegistered(x.GUID())) {
                System.out.println(x.GUID() + " is not a valid StatMod.");
                return true;
            }
            return false;
        });
    }

    @Override
    default public int getRarityRank() {
        return 0;
    }

    default public Rarity getRarity() {
        return Rarities.Gears.get(this.getRarityRank());
    }

    @Override
    default public int getTier() {
        return 0;
    }

    default public String getInvalidGuidMessage() {
        return "Non [a-z0-9_.-] character in Mine and Slash GUID: " + this.GUID() + " of type " + this.getSlashRegistryType().name();
    }
}

