/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.registry;

import com.google.common.collect.Lists;
import com.robertx22.mine_and_slash.config.dimension_configs.DimensionConfig;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.data_generation.compatible_items.CompatibleItem;
import com.robertx22.mine_and_slash.database.affixes.BaseAffix;
import com.robertx22.mine_and_slash.database.bosses.base.Boss;
import com.robertx22.mine_and_slash.database.bosses.impl.NecromancerBoss;
import com.robertx22.mine_and_slash.database.chaos_stats.ChaosStat;
import com.robertx22.mine_and_slash.database.currency.OrbOfTransmutationItem;
import com.robertx22.mine_and_slash.database.currency.base.CurrencyItem;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.item_modifications.bases.BaseItemModification;
import com.robertx22.mine_and_slash.database.item_modifications.gear_items.AddChaosStatMod;
import com.robertx22.mine_and_slash.database.loot_crates.CommonerCrate;
import com.robertx22.mine_and_slash.database.loot_crates.bases.LootCrate;
import com.robertx22.mine_and_slash.database.map_affixes.BaseMapAffix;
import com.robertx22.mine_and_slash.database.mob_affixes.base.MobAffix;
import com.robertx22.mine_and_slash.database.runes.base.BaseRune;
import com.robertx22.mine_and_slash.database.runewords.RuneWord;
import com.robertx22.mine_and_slash.database.sets.Set;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkEffect;
import com.robertx22.mine_and_slash.database.talent_tree.data.StartPerkEffects;
import com.robertx22.mine_and_slash.database.tiers.base.Tier;
import com.robertx22.mine_and_slash.database.tiers.impl.TierOne;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.database.world_providers.DungeonDimension;
import com.robertx22.mine_and_slash.database.world_providers.base.BaseDungeonDimension;
import com.robertx22.mine_and_slash.db_lists.initializers.Bosses;
import com.robertx22.mine_and_slash.db_lists.initializers.ChaosStats;
import com.robertx22.mine_and_slash.db_lists.initializers.GearTypes;
import com.robertx22.mine_and_slash.db_lists.initializers.ItemModifications;
import com.robertx22.mine_and_slash.db_lists.initializers.LootCrates;
import com.robertx22.mine_and_slash.db_lists.initializers.MapAffixes;
import com.robertx22.mine_and_slash.db_lists.initializers.MobAffixes;
import com.robertx22.mine_and_slash.db_lists.initializers.PerkEffectsInit;
import com.robertx22.mine_and_slash.db_lists.initializers.Perks;
import com.robertx22.mine_and_slash.db_lists.initializers.PotionEffects;
import com.robertx22.mine_and_slash.db_lists.initializers.Prefixes;
import com.robertx22.mine_and_slash.db_lists.initializers.RuneWords;
import com.robertx22.mine_and_slash.db_lists.initializers.Runes;
import com.robertx22.mine_and_slash.db_lists.initializers.Sets;
import com.robertx22.mine_and_slash.db_lists.initializers.Spells;
import com.robertx22.mine_and_slash.db_lists.initializers.StatMods;
import com.robertx22.mine_and_slash.db_lists.initializers.Stats;
import com.robertx22.mine_and_slash.db_lists.initializers.Suffixes;
import com.robertx22.mine_and_slash.db_lists.initializers.Synergies;
import com.robertx22.mine_and_slash.db_lists.initializers.Tiers;
import com.robertx22.mine_and_slash.db_lists.initializers.UniqueGears;
import com.robertx22.mine_and_slash.db_lists.initializers.WorldProviders;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.RegistryPacket;
import com.robertx22.mine_and_slash.potion_effects.bases.BasePotionEffect;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.ModEntityContainer;
import com.robertx22.mine_and_slash.registry.SlashRegistryContainer;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyAffix;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyGearType;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyMapAffix;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyRune;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyRuneWord;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptySet;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptySpell;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyStat;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyStatMod;
import com.robertx22.mine_and_slash.registry.empty_entries.EmptyUnique;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.IWorld;

public class SlashRegistry {
    private static HashMap<SlashRegistryType, SlashRegistryContainer> SERVER = new HashMap();
    private static HashMap<SlashRegistryType, SlashRegistryContainer> BACKUP = new HashMap();

    public static void backup() {
        BACKUP = new HashMap<SlashRegistryType, SlashRegistryContainer>(SERVER);
    }

    public static void restoreBackup() {
        SERVER = new HashMap<SlashRegistryType, SlashRegistryContainer>(BACKUP);
    }

    public static void restoreFromBackupifEmpty() {
        if (SlashRegistry.UniqueGears().isEmpty() || SlashRegistry.Runes().isEmpty() || SlashRegistry.Affixes().isEmpty()) {
            SlashRegistry.restoreBackup();
        }
    }

    public static DimensionConfig getDimensionConfig(IWorld world) {
        String id = MapManager.getId(world);
        return SlashRegistry.DimensionConfigs().get(id);
    }

    public static ModEntityConfig getEntityConfig(LivingEntity entity, EntityCap.UnitData data) {
        String monster_id = entity.func_200600_R().getRegistryName().toString();
        String mod_id = entity.func_200600_R().getRegistryName().func_110624_b();
        ModEntityConfig config = null;
        if (SlashRegistry.EntityConfigs().isRegistered(monster_id) ? (config = (ModEntityConfig)SlashRegistry.EntityConfigs().get(monster_id)) != null : (SlashRegistry.EntityConfigs().isRegistered(mod_id) ? (config = (ModEntityConfig)SlashRegistry.EntityConfigs().get(mod_id)) != null : (config = SlashRegistry.EntityConfigs().byEntityTypeDefault.get((Object)data.getType())) != null)) {
            return config;
        }
        return (ModEntityConfig)SlashRegistry.EntityConfigs().getDefault();
    }

    public static SlashRegistryContainer<Synergy> Synergies() {
        return SlashRegistry.getRegistry(SlashRegistryType.SPELL_SYNERGY);
    }

    public static SlashRegistryContainer<PerkEffect> PerkEffects() {
        return SlashRegistry.getRegistry(SlashRegistryType.PERK_EFFECT);
    }

    public static SlashRegistryContainer<BasePotionEffect> PotionEffects() {
        return SlashRegistry.getRegistry(SlashRegistryType.EFFECT);
    }

    public static SlashRegistryContainer<Perk> Perks() {
        return SlashRegistry.getRegistry(SlashRegistryType.PERK);
    }

    public static SlashRegistryContainer<CurrencyItem> CurrencyItems() {
        return SlashRegistry.getRegistry(SlashRegistryType.CURRENCY_ITEMS);
    }

    public static SlashRegistryContainer<ChaosStat> ChaosStats() {
        return SlashRegistry.getRegistry(SlashRegistryType.CHAOS_STAT);
    }

    private static SlashRegistryContainer<DimensionConfig> DimensionConfigs() {
        return SlashRegistry.getRegistry(SlashRegistryType.DIMENSION_CONFIGS);
    }

    public static SlashRegistryContainer<BaseItemModification> ItemModifications() {
        return SlashRegistry.getRegistry(SlashRegistryType.ITEM_MODIFICATION);
    }

    public static SlashRegistryContainer<LootCrate> LootCrates() {
        return SlashRegistry.getRegistry(SlashRegistryType.LOOT_CRATE);
    }

    public static SlashRegistryContainer<CompatibleItem> CompatibleItems() {
        return SlashRegistry.getRegistry(SlashRegistryType.COMPATIBLE_ITEM);
    }

    public static SlashRegistryContainer<BaseMapAffix> MapAffixes() {
        return SlashRegistry.getRegistry(SlashRegistryType.MAP_AFFIX);
    }

    public static SlashRegistryContainer<IUnique> UniqueGears() {
        return SlashRegistry.getRegistry(SlashRegistryType.UNIQUE_GEAR);
    }

    public static SlashRegistryContainer<Set> Sets() {
        return SlashRegistry.getRegistry(SlashRegistryType.SET);
    }

    public static SlashRegistryContainer<BaseAffix> Affixes() {
        return SlashRegistry.getRegistry(SlashRegistryType.AFFIX);
    }

    public static SlashRegistryContainer<Tier> Tiers() {
        return SlashRegistry.getRegistry(SlashRegistryType.TIER);
    }

    public static SlashRegistryContainer<GearItemSlot> GearTypes() {
        return SlashRegistry.getRegistry(SlashRegistryType.GEAR_TYPE);
    }

    public static SlashRegistryContainer<BaseSpell> Spells() {
        return SlashRegistry.getRegistry(SlashRegistryType.SPELL);
    }

    public static SlashRegistryContainer<BaseRune> Runes() {
        return SlashRegistry.getRegistry(SlashRegistryType.RUNE);
    }

    public static SlashRegistryContainer<MobAffix> MobAffixes() {
        return SlashRegistry.getRegistry(SlashRegistryType.MOB_AFFIX);
    }

    public static SlashRegistryContainer<RuneWord> RuneWords() {
        return SlashRegistry.getRegistry(SlashRegistryType.RUNEWORD);
    }

    public static SlashRegistryContainer<Boss> Bosses() {
        return SlashRegistry.getRegistry(SlashRegistryType.BOSS);
    }

    public static SlashRegistryContainer<BaseDungeonDimension> WorldProviders() {
        return SlashRegistry.getRegistry(SlashRegistryType.WORLD_PROVIDER);
    }

    public static ModEntityContainer EntityConfigs() {
        return (ModEntityContainer)SlashRegistry.getRegistry(SlashRegistryType.MOD_ENTITY_CONFIGS);
    }

    public static SlashRegistryContainer<Stat> Stats() {
        return SlashRegistry.getRegistry(SlashRegistryType.STAT);
    }

    public static SlashRegistryContainer<StatMod> StatMods() {
        return SlashRegistry.getRegistry(SlashRegistryType.STATMOD);
    }

    public static List<SlashRegistryContainer> getAllRegistries() {
        return new ArrayList<SlashRegistryContainer>(SERVER.values());
    }

    public static SlashRegistryContainer getRegistry(SlashRegistryType type) {
        return SERVER.get((Object)type);
    }

    public static ISlashRegistryEntry get(SlashRegistryType type, String guid) {
        return SlashRegistry.getRegistry(type).get(guid);
    }

    public static void registerAllItems() {
        try {
            SlashRegistry.registerFromAllInits();
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
        }
    }

    public static void sendAllPacketsToClientOnLogin(ServerPlayerEntity player) {
        SlashRegistry.getAllRegistries().forEach(x -> {
            if (x.getType().getSerializer() != null) {
                try {
                    List list = x.getFromDatapacks();
                    if (list.size() < 100) {
                        MMORPG.sendToClient(new RegistryPacket(x.getType(), list), player);
                    } else {
                        for (List part : Lists.partition(list, (int)100)) {
                            MMORPG.sendToClient(new RegistryPacket(x.getType(), part), player);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void checkGuidValidity() {
        SERVER.values().forEach(c -> c.getAllIncludingSeriazable().forEach(x -> {
            ISlashRegistryEntry entry = (ISlashRegistryEntry)x;
            if (!entry.isGuidFormattedCorrectly()) {
                throw new RuntimeException(entry.getInvalidGuidMessage());
            }
        }));
    }

    public static void unregisterInvalidEntries() {
        System.out.println("Starting Mine and Slash Registry auto validation.");
        ArrayList invalid = new ArrayList();
        SERVER.values().forEach(c -> c.getList().forEach(x -> {
            ISlashRegistryEntry entry = (ISlashRegistryEntry)x;
            if (!entry.isRegistryEntryValid()) {
                invalid.add(entry);
            }
        }));
        invalid.forEach(x -> x.unregisterDueToInvalidity());
        if (invalid.isEmpty()) {
            System.out.println("All Mine and Slash registries appear valid.");
        } else {
            System.out.println(invalid.size() + " Mine and Slash entries are INVALID!");
        }
    }

    private static void registerFromAllInits() {
        new Tiers().registerAll();
        new Spells().registerAll();
        new Synergies().registerAll();
        new PotionEffects().registerAll();
        new Stats().registerAll();
        new StatMods().registerAll();
        new Runes().registerAll();
        new RuneWords().registerAll();
        new GearTypes().registerAll();
        new MapAffixes().registerAll();
        new Prefixes().registerAll();
        new Suffixes().registerAll();
        new UniqueGears().registerAll();
        new WorldProviders().registerAll();
        new Sets().registerAll();
        new ItemModifications().registerAll();
        new MobAffixes().registerAll();
        new PerkEffectsInit().registerAll();
        new Perks().registerAll();
        new LootCrates().registerAll();
        new Bosses().registerAll();
        new ChaosStats().registerAll();
    }

    private static void addRegistry(SlashRegistryContainer cont) {
        SERVER.put(cont.getType(), cont);
    }

    public static void initRegistries() {
        SERVER = new HashMap();
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyRune>(SlashRegistryType.RUNE, EmptyRune.getInstance()).isDatapack());
        SlashRegistry.addRegistry(new SlashRegistryContainer<TierOne>(SlashRegistryType.TIER, new TierOne()).isDatapack());
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyUnique>(SlashRegistryType.UNIQUE_GEAR, EmptyUnique.getInstance()).isDatapack());
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyAffix>(SlashRegistryType.AFFIX, EmptyAffix.getInstance()).isDatapack());
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyRuneWord>(SlashRegistryType.RUNEWORD, EmptyRuneWord.getInstance()).isDatapack());
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptySet>(SlashRegistryType.SET, new EmptySet()).isDatapack());
        SlashRegistry.addRegistry(new SlashRegistryContainer<MobAffix>(SlashRegistryType.MOB_AFFIX, MobAffixes.EMPTY).isDatapack());
        SlashRegistry.addRegistry(new SlashRegistryContainer<CompatibleItem>(SlashRegistryType.COMPATIBLE_ITEM, CompatibleItem.EMPTY).dontErrorIfEmpty().isDatapack().logAdditions());
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyGearType>(SlashRegistryType.GEAR_TYPE, new EmptyGearType()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyStat>(SlashRegistryType.STAT, EmptyStat.getInstance()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyStatMod>(SlashRegistryType.STATMOD, EmptyStatMod.getInstance()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<ChaosStat>(SlashRegistryType.CHAOS_STAT, ChaosStat.empty()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptySpell>(SlashRegistryType.SPELL, new EmptySpell()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<Object>(SlashRegistryType.SPELL_SYNERGY, null));
        SlashRegistry.addRegistry(new SlashRegistryContainer<EmptyMapAffix>(SlashRegistryType.MAP_AFFIX, new EmptyMapAffix()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<DungeonDimension>(SlashRegistryType.WORLD_PROVIDER, new DungeonDimension(null, null)));
        SlashRegistry.addRegistry(new SlashRegistryContainer<AddChaosStatMod>(SlashRegistryType.ITEM_MODIFICATION, new AddChaosStatMod()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<OrbOfTransmutationItem>(SlashRegistryType.CURRENCY_ITEMS, new OrbOfTransmutationItem()));
        SlashRegistry.addRegistry(new SlashRegistryContainer<Object>(SlashRegistryType.EFFECT, null));
        SlashRegistry.addRegistry(new SlashRegistryContainer<DimensionConfig>(SlashRegistryType.DIMENSION_CONFIGS, DimensionConfig.DefaultExtra()).logAdditions().dontErrorMissingEntriesOnAccess());
        SlashRegistry.addRegistry(new ModEntityContainer(SlashRegistryType.MOD_ENTITY_CONFIGS).logAdditions());
        SlashRegistry.addRegistry(new SlashRegistryContainer<Object>(SlashRegistryType.PERK, null));
        SlashRegistry.addRegistry(new SlashRegistryContainer<PerkEffect>(SlashRegistryType.PERK_EFFECT, StartPerkEffects.GUARDIAN));
        SlashRegistry.addRegistry(new SlashRegistryContainer<CommonerCrate>(SlashRegistryType.LOOT_CRATE, CommonerCrate.INSTANCE));
        SlashRegistry.addRegistry(new SlashRegistryContainer<NecromancerBoss>(SlashRegistryType.BOSS, NecromancerBoss.getInstance()));
    }
}

