/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.registry;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.registry.FilterListWrap;
import com.robertx22.mine_and_slash.registry.ISlashRegistryEntry;
import com.robertx22.mine_and_slash.registry.SlashRegistryType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SlashRegistryContainer<C extends ISlashRegistryEntry> {
    private List<String> registersErrorsAlertedFor = new ArrayList<String>();
    private List<String> accessorErrosAletedFor = new ArrayList<String>();
    private List<String> wrongRegistryNames = new ArrayList<String>();
    private List<String> emptyRegistries = new ArrayList<String>();
    private boolean dataPacksAreRegistered = true;
    private HashMap<String, C> serializables = new HashMap();
    private SlashRegistryType type;
    private C emptyDefault;
    private HashMap<String, C> map = new HashMap();
    private boolean errorIfEmpty = true;
    private boolean logAdditionsToRegistry = false;
    private boolean logMissingEntryOnAccess = true;

    public SlashRegistryContainer<C> isDatapack() {
        this.dataPacksAreRegistered = false;
        return this;
    }

    public List<C> getSerializable() {
        return new ArrayList<C>(this.serializables.values());
    }

    public List<C> getFromDatapacks() {
        return this.getList().stream().filter(x -> x.isFromDatapack()).collect(Collectors.toList());
    }

    public SlashRegistryType getType() {
        return this.type;
    }

    public static void logRegistryError(String text) {
        try {
            throw new Exception("[Mine and Slash Registry Error]: " + text);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    protected C getDefault() {
        return this.emptyDefault;
    }

    public SlashRegistryContainer logAdditions() {
        this.logAdditionsToRegistry = true;
        return this;
    }

    public void unRegister(ISlashRegistryEntry entry) {
        this.map.remove(entry.GUID());
    }

    public SlashRegistryContainer dontErrorMissingEntriesOnAccess() {
        this.logMissingEntryOnAccess = false;
        return this;
    }

    public SlashRegistryContainer dontErrorIfEmpty() {
        this.errorIfEmpty = false;
        return this;
    }

    public int getSize() {
        return this.map.size();
    }

    public SlashRegistryContainer(SlashRegistryType type, C emptyDefault) {
        this.type = type;
        this.emptyDefault = emptyDefault;
    }

    public void setDefault(C c) {
        this.emptyDefault = c;
    }

    private void tryLogEmptyRegistry() {
        if (this.errorIfEmpty && this.map.isEmpty() && this.dataPacksAreRegistered && this.emptyRegistries.contains(this.type.id)) {
            this.emptyRegistries.add(this.type.id);
            SlashRegistryContainer.logRegistryError("Slash Registry of type: " + this.type.toString() + " is empty, this is really bad!");
        }
    }

    public HashMap<String, C> getAll() {
        this.tryLogEmptyRegistry();
        return this.map;
    }

    public List<C> getList() {
        return new ArrayList<C>(this.map.values());
    }

    public List<C> getAllIncludingSeriazable() {
        ArrayList<C> list = new ArrayList<C>(this.map.values());
        list.addAll(this.serializables.values());
        return list;
    }

    public void unregisterAllEntriesFromDatapacks() {
        new HashMap<String, C>(this.map).entrySet().forEach(x -> {
            if (((ISlashRegistryEntry)x.getValue()).isFromDatapack()) {
                this.map.remove(x.getKey());
            }
        });
    }

    public C get(String guid) {
        String id = IGUID.getformattedString(guid);
        this.tryLogEmptyRegistry();
        if (id == null || id.isEmpty()) {
            return this.getDefault();
        }
        if (this.map.containsKey(id)) {
            return (C)((ISlashRegistryEntry)this.map.get(id));
        }
        if (this.logMissingEntryOnAccess && !this.accessorErrosAletedFor.contains(id)) {
            SlashRegistryContainer.logRegistryError("GUID Error: " + id + " of type: " + this.type.toString() + " doesn't exist. This is either a removed/renamed old registry, or robertx22 forgot to include it in an update.");
            this.accessorErrosAletedFor.add(id);
        }
        return this.getDefault();
    }

    public FilterListWrap<C> getWrapped() {
        return new FilterListWrap<C>(this.map.values());
    }

    public FilterListWrap<C> getFilterWrapped(Predicate<C> pred) {
        return new FilterListWrap<C>(this.getFiltered(pred));
    }

    public List<C> getFiltered(Predicate<C> predicate) {
        return this.getList().stream().filter(predicate).collect(Collectors.toList());
    }

    public C random() {
        return (C)((ISlashRegistryEntry)RandomUtils.weightedRandom(this.getList()));
    }

    public boolean isRegistered(C c) {
        String id = c.formattedGUID();
        return this.map.containsKey(id);
    }

    public boolean isRegistered(String guid) {
        String id = IGUID.getformattedString(guid);
        return this.map.containsKey(id);
    }

    public void registerOverride(C c) {
        if (this.isRegistered(c)) {
            System.out.println("[Mine and Slash Registry Note]: Overriding: " + c.GUID());
        }
        this.map.put(c.GUID(), c);
    }

    public void register(C c) {
        if (this.isRegistered(c)) {
            if (!this.registersErrorsAlertedFor.contains(c.GUID())) {
                SlashRegistryContainer.logRegistryError("Key: " + c.GUID() + " has already been registered to: " + c.getSlashRegistryType().toString() + " registry.");
                this.registersErrorsAlertedFor.add(c.GUID());
            }
        } else {
            this.tryLogAddition(c);
            this.map.put(c.GUID(), c);
        }
    }

    private void tryLogAddition(C c) {
        if (this.logAdditionsToRegistry && ((Boolean)ModConfig.INSTANCE.Server.LOG_REGISTRY_ENTRIES.get()).booleanValue()) {
            System.out.println("[Mine and Slash Registry Addition]: " + c.GUID() + " to " + this.type.toString() + " registry");
        }
    }

    public void addSerializable(C entry) {
        this.serializables.put(entry.GUID(), entry);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

