/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.EntityCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Utilities;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;

@Storable
public class EntitySpellData {
    @Store
    public float charge = 1.0f;
    @Store
    public boolean activated = false;
    @Store
    private String casterID;
    private LivingEntity caster;
    @Store
    public int lifeInTicks = 100;
    @Store
    public int ticksExisted = 0;
    @Store
    public EntityCalcSpellConfigs configs;
    @Store
    private String spellGUID = "";
    private BaseSpell spell;

    public Elements getElement() {
        if (this.getSpell() != null) {
            return this.getSpell().getElement();
        }
        return Elements.Physical;
    }

    public int getRemainingLifeTicks() {
        return this.lifeInTicks - this.ticksExisted;
    }

    public EntitySpellData(BaseSpell spell, LivingEntity caster, EntityCalcSpellConfigs config) {
        if (spell != null) {
            this.spellGUID = spell.GUID();
        }
        this.casterID = caster.func_110124_au().toString();
        this.lifeInTicks = config.get(SC.DURATION_TICKS).intValue();
        this.configs = config;
    }

    private UUID getCasterUUID() {
        return UUID.fromString(this.casterID);
    }

    public EntitySpellData() {
    }

    public BaseSpell getSpell() {
        if (this.spell == null) {
            this.spell = SlashRegistry.Spells().get(this.spellGUID);
        }
        return this.spell;
    }

    public LivingEntity getCaster(World world) {
        if (this.caster == null) {
            this.caster = Utilities.getLivingEntityByUUID(world, this.getCasterUUID());
        }
        return this.caster;
    }
}

