/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

@Storable
public class PlayerTeamsData {
    @Store
    public HashMap<String, String> playerIDxTeamIDMap = new HashMap();
    @Store
    public HashMap<String, Team> teamIDxTeamDataMap = new HashMap();

    public String getTeamId(PlayerEntity player) {
        return this.playerIDxTeamIDMap.getOrDefault(PlayerTeamsData.getPlayerId(player), "");
    }

    public static String getPlayerId(PlayerEntity player) {
        return player.func_110124_au().toString();
    }

    @Storable
    public static class Team {
        @Store
        String owner = "";
        @Store
        Set<String> players = new HashSet<String>();
        @Store
        Set<String> invites = new HashSet<String>();

        public void invite(ServerPlayerEntity player) {
            this.invites.add(PlayerTeamsData.getPlayerId((PlayerEntity)player));
            player.func_145747_a(this.getPlayer(this.owner).func_145748_c_().func_150258_a(" invited you to a party. Do /slash party join ").func_150257_a(this.getPlayer(this.owner).func_145748_c_()).func_150258_a(" to join."));
        }

        public boolean tryJoin(ServerPlayerEntity player) {
            String playerID = PlayerTeamsData.getPlayerId((PlayerEntity)player);
            if (this.players.contains(playerID)) {
                player.func_145747_a((ITextComponent)new SText("You are already inside the team."));
                return false;
            }
            if (this.invites.contains(playerID)) {
                this.invites.removeIf(x -> playerID.equals(x));
                this.players.add(playerID);
                player.func_145747_a((ITextComponent)new SText("Team joined."));
                return true;
            }
            player.func_145747_a((ITextComponent)new SText("Can't join team, you aren't invited."));
            return false;
        }

        public void addPlayer(ServerPlayerEntity player) {
            this.players.add(PlayerTeamsData.getPlayerId((PlayerEntity)player));
            if (this.owner.isEmpty()) {
                this.owner = PlayerTeamsData.getPlayerId((PlayerEntity)player);
            }
        }

        public PlayerEntity getPlayer(String id) {
            return MapManager.getServer().func_184103_al().func_177451_a(UUID.fromString(id));
        }

        public void removePlayer(ServerPlayerEntity player) {
            this.players.removeIf(x -> PlayerTeamsData.getPlayerId((PlayerEntity)player).equals(x));
        }

        public Set<String> getPlayerIds() {
            return this.players;
        }
    }
}

