/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.HealEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.ModifyResourceEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellHealEffect;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@Storable
public class ResourcesData {
    @Store
    private float energy = 0.0f;
    @Store
    private float mana = 0.0f;
    @Store
    private float magicShield = 0.0f;
    @Store
    private float blood = 0.0f;

    public float getEnergy() {
        return this.energy;
    }

    public float getMana() {
        return this.mana;
    }

    public float getBlood() {
        return this.blood;
    }

    public float getMagicShield() {
        return this.magicShield;
    }

    public float getHealth(EntityCap.UnitData data, LivingEntity entity) {
        return data.getUnit().health().CurrentValue(entity, data.getUnit());
    }

    public float getModifiedValue(Context ctx) {
        if (ctx.use == Use.RESTORE) {
            return this.get(ctx) + ctx.amount;
        }
        return this.get(ctx) - ctx.amount;
    }

    private float get(Context ctx) {
        if (ctx.type == Type.ENERGY) {
            return this.energy;
        }
        if (ctx.type == Type.MANA) {
            return this.mana;
        }
        if (ctx.type == Type.MAGIC_SHIELD) {
            return this.magicShield;
        }
        if (ctx.type == Type.BLOOD) {
            return this.blood;
        }
        if (ctx.type == Type.HEALTH) {
            return ctx.targetData.getUnit().health().CurrentValue(ctx.target, ctx.targetData.getUnit());
        }
        return 0.0f;
    }

    private void modifyBy(Context ctx) {
        if (ctx.type == Type.ENERGY) {
            this.energy = MathHelper.func_76131_a((float)this.getModifiedValue(ctx), (float)0.0f, (float)ctx.targetData.getUnit().energyData().getAverageValue());
        } else if (ctx.type == Type.MANA) {
            this.mana = MathHelper.func_76131_a((float)this.getModifiedValue(ctx), (float)0.0f, (float)ctx.targetData.getUnit().manaData().getAverageValue());
        } else if (ctx.type == Type.MAGIC_SHIELD) {
            this.magicShield = MathHelper.func_76131_a((float)this.getModifiedValue(ctx), (float)0.0f, (float)ctx.targetData.getUnit().magicShieldData().getAverageValue());
        } else if (ctx.type == Type.BLOOD) {
            this.blood = MathHelper.func_76131_a((float)this.getModifiedValue(ctx), (float)0.0f, (float)ctx.targetData.getUnit().getMaximumBlood());
        } else if (ctx.type == Type.HEALTH) {
            if (ctx.use == Use.RESTORE) {
                this.heal(ctx);
            } else {
                ctx.target.func_70606_j(HealthUtils.DamageToMinecraftHealth(this.getModifiedValue(ctx), ctx.target, ctx.targetData));
            }
        }
    }

    private void heal(Context ctx) {
        if (ctx.target.func_70089_S()) {
            if (ctx.spell != null) {
                SpellHealEffect effect = new SpellHealEffect(ctx);
                effect.Activate();
            } else {
                HealEffect effect = new HealEffect(ctx);
                effect.Activate();
            }
        }
    }

    public boolean hasEnough(Context ctx) {
        if (ctx.amount <= 0.0f) {
            return true;
        }
        return this.get(ctx) >= ctx.amount;
    }

    public void modify(Context ctx) {
        this.modifyBy(ctx);
    }

    public static enum Use {
        SPEND,
        RESTORE;

    }

    public static enum Type {
        HEALTH,
        MANA,
        ENERGY,
        MAGIC_SHIELD,
        BLOOD;

    }

    public static class Context {
        public BaseSpell spell;
        public EntityCap.UnitData sourceData;
        public LivingEntity source;
        public EntityCap.UnitData targetData;
        public LivingEntity target;
        public Type type;
        public float amount;
        public Use use;
        public boolean statsCalculated = false;

        public Context(EntityCap.UnitData data, LivingEntity entity, Type type, float amount, Use use, BaseSpell spell) {
            this.targetData = data;
            this.target = entity;
            this.sourceData = data;
            this.source = entity;
            this.type = type;
            this.amount = amount;
            this.use = use;
            this.spell = spell;
            this.calculateStats();
        }

        public Context(EntityCap.UnitData data, LivingEntity entity, Type type, float amount, Use use) {
            this.targetData = data;
            this.target = entity;
            this.sourceData = data;
            this.source = entity;
            this.type = type;
            this.amount = amount;
            this.use = use;
            this.calculateStats();
        }

        public Context(LivingEntity caster, LivingEntity target, Type type, float amount, Use use, BaseSpell spell) {
            this.targetData = Load.Unit((ICapabilityProvider)target);
            this.target = target;
            this.sourceData = Load.Unit((ICapabilityProvider)caster);
            this.source = caster;
            this.type = type;
            this.amount = amount;
            this.use = use;
            this.spell = spell;
            this.calculateStats();
        }

        public Context(LivingEntity caster, LivingEntity target, EntityCap.UnitData casterData, EntityCap.UnitData targetData, Type type, float amount, Use use, BaseSpell spell) {
            this.targetData = targetData;
            this.target = target;
            this.sourceData = casterData;
            this.source = caster;
            this.type = type;
            this.amount = amount;
            this.use = use;
            this.calculateStats();
        }

        private void calculateStats() {
            if (!this.statsCalculated) {
                new ModifyResourceEffect(this).Activate();
            }
        }
    }
}

