/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatModTypes;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.text.DecimalFormat;
import net.minecraft.util.math.MathHelper;

@Storable
public class StatData {
    private static StatData empty = new StatData();
    @Store
    private String id = "";
    private float Flat = 0.0f;
    private float Flat2 = 0.0f;
    private float Percent = 0.0f;
    private float Multi = 0.0f;
    @Store
    private float val = 0.0f;
    @Store
    private float v2 = 0.0f;

    public static StatData empty() {
        return empty;
    }

    public StatData() {
    }

    public StatData(Stat stat) {
        this.id = stat.GUID();
    }

    public Stat GetStat() {
        return SlashRegistry.Stats().get(this.id);
    }

    public String toSerializationString() {
        return this.id + ":" + this.val + ":" + this.v2;
    }

    public static StatData fromSerializationString(String str) {
        StatData obj = new StatData();
        String[] parts = str.split(":");
        obj.id = parts[0];
        obj.val = Float.parseFloat(parts[1]);
        obj.v2 = Float.parseFloat(parts[2]);
        return obj;
    }

    public void addFlat(float val1) {
        this.Flat += val1;
        this.Flat2 += val1;
    }

    public float getFlatAverage() {
        return (this.Flat + this.Flat2) / 2.0f;
    }

    public void CalcVal(EntityCap.UnitData data) {
        Stat stat = this.GetStat();
        this.calcFirstValue(data);
        this.calcSecondValue(data);
    }

    private void calcFirstValue(EntityCap.UnitData data) {
        Stat stat = this.GetStat();
        if (stat.isTrait()) {
            this.val = this.Flat > 0.0f ? 1.0f : 0.0f;
            return;
        }
        float finalValue = stat.BaseFlat;
        finalValue = stat.getScaling().scale(stat.BaseFlat, data.getLevel());
        finalValue += this.Flat;
        finalValue *= 1.0f + this.Percent / 100.0f;
        this.val = MathHelper.func_76131_a((float)(finalValue *= 1.0f + this.Multi / 100.0f), (float)stat.minimumValue, (float)stat.maximumValue);
    }

    private void calcSecondValue(EntityCap.UnitData data) {
        Stat stat = this.GetStat();
        if (stat.isTrait()) {
            this.v2 = this.Flat2 > 0.0f ? 1.0f : 0.0f;
            return;
        }
        float finalValue = stat.BaseFlat;
        finalValue = stat.getScaling().scale(stat.BaseFlat, data.getLevel());
        finalValue += this.Flat2;
        finalValue *= 1.0f + this.Percent / 100.0f;
        this.v2 = MathHelper.func_76131_a((float)(finalValue *= 1.0f + this.Multi / 100.0f), (float)stat.minimumValue, (float)stat.maximumValue);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setValue(float val) {
        Stat stat = this.GetStat();
        this.val = MathHelper.func_76131_a((float)val, (float)stat.minimumValue, (float)stat.maximumValue);
    }

    public void addMulti(float multi) {
        this.Multi += multi;
    }

    public void addPercent(float percent) {
        this.Percent += percent;
    }

    public float getFirstValue() {
        return this.val;
    }

    public float getSecondValue() {
        return this.v2;
    }

    public float getAverageValue() {
        float val = (this.getFirstValue() + this.getSecondValue()) / 2.0f;
        Stat stat = this.GetStat();
        return MathHelper.func_76131_a((float)val, (float)stat.minimumValue, (float)stat.maximumValue);
    }

    public boolean isNotZero() {
        return this.val != 0.0f && this.v2 != 0.0f;
    }

    public float getRandomRangeValue() {
        return RandomUtils.RandomRange(this.getFirstValue(), this.getSecondValue());
    }

    public boolean isMoreThanZero() {
        return this.val > 0.0f || this.v2 > 0.0f;
    }

    public void add(StatModData modData, int level) {
        StatModTypes type = modData.getType();
        Float v1 = Float.valueOf(modData.getFirstValue(level));
        Float v2 = Float.valueOf(modData.getSecondValue(level));
        Float v = Float.valueOf((v1.floatValue() + v2.floatValue()) / 2.0f);
        if (type == StatModTypes.Flat) {
            this.Flat += v1.floatValue();
            this.Flat2 += v2.floatValue();
        } else if (type == StatModTypes.Percent) {
            this.Percent += v.floatValue();
        } else if (type == StatModTypes.Multi) {
            this.Multi += v.floatValue();
        }
    }

    public void transferAllPreCalcTo(StatData other) {
        this.addFullyTo(other);
        this.Clear();
        this.val = 0.0f;
        this.v2 = 0.0f;
    }

    public void addFullyTo(StatData other) {
        other.Flat += this.Flat;
        other.Flat2 += this.Flat2;
        other.Percent += this.Percent;
        other.Multi += this.Multi;
    }

    public void addExact(StatModTypes type, float value) {
        if (type == StatModTypes.Flat) {
            this.addFlat(value);
        } else if (type == StatModTypes.Percent) {
            this.Percent += value;
        } else {
            this.Multi += value;
        }
    }

    public void addExact(StatData data) {
        if (data.id.equals(this.id)) {
            this.Flat += data.Flat;
            this.Flat2 += data.Flat2;
            this.Percent += data.Percent;
            this.Multi += data.Multi;
        }
    }

    public void addFlat(float val, int lvl) {
        this.Flat += this.GetStat().calculateScalingStatGrowth(val, lvl);
        this.Flat2 += this.GetStat().calculateScalingStatGrowth(val, lvl);
    }

    public void Clear() {
        this.Flat = 0.0f;
        this.Flat2 = 0.0f;
        this.Percent = 0.0f;
        this.Multi = 0.0f;
    }

    public String formattedValue() {
        float val = this.getAverageValue();
        DecimalFormat format = new DecimalFormat();
        if (Math.abs(val) < 10.0f) {
            format.setMaximumFractionDigits(1);
            return format.format(val);
        }
        int intval = (int)val;
        return intval + "";
    }

    public float getMultiplier() {
        return 1.0f + this.getAverageValue() / 100.0f;
    }

    public float getReverseMultiplier() {
        return 1.0f - this.getAverageValue() / 100.0f;
    }

    public boolean isNotEmpty() {
        return this.Flat != 0.0f || this.val != 0.0f || this.Percent != 0.0f || this.Multi != 0.0f;
    }

    public void multiplyFlat(float multi) {
        this.Flat *= multi;
        this.Flat2 *= multi;
    }

    public void multiplyFlat(double multi) {
        this.Flat = (float)((double)this.Flat * multi);
        this.Flat2 = (float)((double)this.Flat2 * multi);
    }
}

