/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses;

import com.robertx22.mine_and_slash.api.MineAndSlashEvents;
import com.robertx22.mine_and_slash.config.dimension_configs.DimensionConfig;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.mob_affixes.base.MobAffix;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.stats.IAfterStatCalc;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.stats.types.game_changers.BloodMage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.database.stats.types.resources.Health;
import com.robertx22.mine_and_slash.database.stats.types.resources.MagicShield;
import com.robertx22.mine_and_slash.database.stats.types.resources.Mana;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.onevent.entity.damage.DamageEventData;
import com.robertx22.mine_and_slash.packets.EfficientMobUnitPacket;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.StatContainer;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.WornSetsContainerData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.BossCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.CommonStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.MobStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.PlayerStatUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

@Storable
public class Unit {
    @Store
    private StatContainer stats = new StatContainer();
    @Store
    public WornSetsContainerData wornSets = new WornSetsContainerData();
    @Store
    public String GUID = UUID.randomUUID().toString();
    @Store
    public String prefix;
    @Store
    public String suffix;
    private static List<EntityType> IGNORED_ENTITIES = null;

    public MobAffix getPrefix() {
        if (this.prefix == null) {
            return null;
        }
        return SlashRegistry.MobAffixes().get(this.prefix);
    }

    public MobAffix getSuffix() {
        if (this.suffix == null) {
            return null;
        }
        return SlashRegistry.MobAffixes().get(this.suffix);
    }

    @Nonnull
    public HashMap<String, StatData> getStats() {
        if (this.stats.stats == null) {
            this.initStats();
        }
        return this.stats.stats;
    }

    @Nonnull
    public StatData getCreateStat(Stat stat) {
        return this.getCreateStat(stat.GUID());
    }

    public boolean hasStat(Stat stat) {
        return this.hasStat(stat.GUID());
    }

    public boolean hasStat(String guid) {
        return this.stats.stats.containsKey(guid);
    }

    public StatData peekAtStat(Stat stat) {
        return this.peekAtStat(stat.GUID());
    }

    @Nonnull
    public StatData peekAtStat(String guid) {
        if (this.stats.stats == null) {
            this.initStats();
        }
        return this.stats.stats.getOrDefault(guid, StatData.empty());
    }

    public void setRandomMobAffixes(MobRarity rarity) {
        if (RandomUtils.roll(rarity.bothAffixesChance())) {
            this.randomizePrefix();
            this.randomizeSuffix();
        } else if (RandomUtils.roll(rarity.oneAffixChance())) {
            if (RandomUtils.roll(50)) {
                this.randomizePrefix();
            } else {
                this.randomizeSuffix();
            }
        }
    }

    public void randomizePrefix() {
        this.prefix = SlashRegistry.MobAffixes().getFilterWrapped(x -> x.isPrefix()).random().GUID();
    }

    public void randomizeSuffix() {
        this.suffix = SlashRegistry.MobAffixes().getFilterWrapped(x -> x.isSuffix()).random().GUID();
    }

    @Nonnull
    public StatData getCreateStat(String guid) {
        StatData data;
        if (this.stats.stats == null) {
            this.initStats();
        }
        if ((data = this.stats.stats.get(guid)) == null) {
            Stat stat = SlashRegistry.Stats().get(guid);
            if (stat != null) {
                this.stats.stats.put(stat.GUID(), new StatData(stat));
                return this.stats.stats.get(stat.GUID());
            }
            return new StatData(new UnknownStat());
        }
        return data;
    }

    public void initStats() {
        this.stats.stats = new HashMap();
    }

    private void removeEmptyStats() {
        for (StatData data : new ArrayList<StatData>(this.stats.stats.values())) {
            if (data.isNotZero() && !data.getId().isEmpty()) continue;
            this.stats.stats.remove(data.getId());
        }
    }

    public void removeUnregisteredStats() {
        if (this.stats.stats == null) {
            this.stats.stats = new HashMap();
        }
        this.removeEmptyStats();
        for (Map.Entry<String, StatData> entry : new ArrayList<Map.Entry<String, StatData>>(this.stats.stats.entrySet())) {
            StatData data = entry.getValue();
            if (SlashRegistry.Stats().isRegistered(data.getId())) continue;
            this.stats.stats.remove(entry.getKey());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Unit) {
            return ((Unit)obj).GUID == this.GUID;
        }
        return false;
    }

    public int hashCode() {
        return this.GUID.hashCode();
    }

    public Health health() {
        return Health.getInstance();
    }

    public Mana mana() {
        return Mana.getInstance();
    }

    public Energy energy() {
        return Energy.getInstance();
    }

    public float getCurrentEffectiveHealth(LivingEntity entity, EntityCap.UnitData data) {
        float curhp = this.health().CurrentValue(entity, this);
        if (data.getResources() != null) {
            curhp += data.getResources().getMagicShield();
        }
        return curhp;
    }

    public float getMaxEffectiveHealth() {
        float hp = this.healthData().getAverageValue();
        return hp += this.magicShieldData().getAverageValue();
    }

    public boolean isBloodMage() {
        return this.hasStat(BloodMage.INSTANCE) && this.getCreateStat(BloodMage.INSTANCE).isMoreThanZero();
    }

    public float getMaximumBlood() {
        if (this.getCreateStat(BloodMage.INSTANCE).getAverageValue() > 0.0f) {
            return this.healthData().getAverageValue() / 2.0f;
        }
        return 0.0f;
    }

    public StatData healthData() {
        try {
            return this.getCreateStat(Health.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public StatData magicShieldData() {
        try {
            return this.getCreateStat(MagicShield.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public StatData manaData() {
        try {
            return this.getCreateStat(Mana.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public StatData energyData() {
        try {
            return this.getCreateStat(Energy.GUID);
        }
        catch (Exception exception) {
            return StatData.empty();
        }
    }

    public int randomRarity(LivingEntity entity, EntityCap.UnitData data, BossCap.IBossData boss) {
        if (boss != null && boss.isBoss()) {
            return -2;
        }
        int level = data.getLevel();
        double y = entity.field_70163_u;
        List rarities = Rarities.Mobs.getNormalRarities();
        if (entity.field_70170_p.field_73012_v.nextBoolean() && entity.field_71093_bK.equals(DimensionType.field_223227_a_)) {
            if (y < 50.0) {
                rarities.removeIf(x -> x.Rank() == 0);
            }
            if (y < 30.0) {
                rarities.removeIf(x -> x.Rank() == 1);
            }
        }
        DimensionConfig config = SlashRegistry.getDimensionConfig((IWorld)entity.field_70170_p);
        if (!WorldUtils.isMapWorldClass((IWorld)entity.field_70170_p) && config.LEVEL_FOR_MOBS_TO_BE_LEGENDARY > level) {
            rarities.removeIf(x -> x.Rank() == 4);
        }
        MobRarity finalRarity = (MobRarity)RandomUtils.weightedRandom(rarities);
        ModEntityConfig entityConfig = SlashRegistry.getEntityConfig(entity, Load.Unit((ICapabilityProvider)entity));
        return MathHelper.func_76125_a((int)finalRarity.Rank(), (int)entityConfig.MIN_RARITY, (int)entityConfig.MAX_RARITY);
    }

    protected void ClearStats() {
        if (this.stats.stats == null) {
            this.initStats();
        }
        for (StatData stat : this.stats.stats.values()) {
            stat.Clear();
        }
    }

    protected void CalcStats(EntityCap.UnitData data) {
        this.stats.stats.values().forEach(stat -> stat.CalcVal(data));
    }

    public float getMissingHealth(LivingEntity en) {
        return this.healthData().getAverageValue() - (float)this.health().CurrentValue(en, this);
    }

    private DirtyCheck getDirtyCheck() {
        if (this.stats.stats == null || this.stats.stats.isEmpty()) {
            this.initStats();
        }
        DirtyCheck check = new DirtyCheck();
        check.hp = (int)this.getCreateStat(Health.GUID).getAverageValue();
        return check;
    }

    private float getHpAdded(LivingEntity entity, MobRarity rar, EntityCap.UnitData data) {
        float hpadded = Health.getInstance().calculateScalingStatGrowth(entity.func_110138_aP(), data.getLevel());
        hpadded = entity instanceof PlayerEntity ? (float)((double)hpadded * (Double)ModConfig.INSTANCE.Server.PLAYER_HEART_TO_HEALTH_CONVERSION.get()) : (hpadded *= 2.0f * rar.HealthMultiplier());
        return hpadded;
    }

    public void recalculateStats(LivingEntity entity, EntityCap.UnitData data, int level, @Nullable DamageEventData dmgData) {
        DirtyCheck newcheck;
        data.setEquipsChanged(false);
        if (data.getUnit() == null) {
            data.setUnit(this, entity);
        }
        DirtyCheck old = this.getDirtyCheck();
        ArrayList<GearItemData> gears = new ArrayList<GearItemData>();
        MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.CollectGearStacksEvent(entity, gears, dmgData));
        boolean gearIsValid = this.isGearCombinationValid(gears, (Entity)entity);
        this.ClearStats();
        MobRarity rar = (MobRarity)Rarities.Mobs.get(data.getRarity());
        float hpadded = this.getHpAdded(entity, rar, data);
        this.getCreateStat(Health.GUID).addFlat(hpadded);
        Boolean isMapWorld = WorldUtils.isMapWorld((IWorld)entity.field_70170_p);
        WorldMapCap.IWorldMapData mapData = Load.world(entity.field_70170_p);
        CommonStatUtils.addPotionStats(entity, data);
        CommonStatUtils.addCustomStats(data, this, level);
        CommonStatUtils.addExactCustomStats(data);
        if (entity instanceof PlayerEntity) {
            PlayerStatUtils.AddPlayerBaseStats(data, this);
            PlayerStatUtils.addTalentStats(data, (PlayerEntity)entity);
            PlayerStatUtils.addSpellTreeStats(data, (PlayerEntity)entity);
            Load.statPoints((PlayerEntity)entity).getData().getAllStatDatas().forEach(x -> x.applyStats(data));
        } else {
            MobStatUtils.AddMobcStats(data, data.getLevel());
            MobStatUtils.addAffixStats(data);
            MobStatUtils.worldMultiplierStats(entity.field_70170_p, this);
            MobStatUtils.increaseMobStatsPerLevel(data);
            if (isMapWorld.booleanValue()) {
                MobStatUtils.increaseMobStatsPerTier(data, this);
            }
            MobStatUtils.modifyMobStatsByConfig(entity, data);
        }
        if (gearIsValid) {
            PlayerStatUtils.countWornSets((Entity)entity, gears, this);
            PlayerStatUtils.AddAllGearStats((Entity)entity, gears, data, level);
            PlayerStatUtils.AddAllSetStats((Entity)entity, data, this, level);
        }
        if (isMapWorld.booleanValue()) {
            CommonStatUtils.AddMapAffixStats(mapData, this, level, entity);
        }
        Unit copy = this.Clone();
        CommonStatUtils.CalcStatConversionsAndTransfers(copy, this);
        CommonStatUtils.CalcTraitsAndCoreStats(data);
        MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.OnStatCalculation(entity, data));
        this.CalcStats(data);
        this.removeEmptyStats();
        if (entity instanceof PlayerEntity) {
            PlayerStatUtils.applyRequirementsUnmetPenalty((Entity)entity, data, gears);
            PlayerSpellCap.ISpellsCap spells = Load.spells(entity);
            spells.getAbilitiesData().clearBonusLevels();
            try {
                this.stats.stats.entrySet().forEach(x -> {
                    Stat stat = ((StatData)x.getValue()).GetStat();
                    if (stat instanceof IAfterStatCalc) {
                        IAfterStatCalc after = (IAfterStatCalc)((Object)stat);
                        ((IAfterStatCalc)((Object)stat)).doAfterStatCalc((StatData)x.getValue(), data, spells);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (old.isDirty(newcheck = this.getDirtyCheck())) {
            if (!Unit.shouldSendUpdatePackets(entity)) {
                return;
            }
            MMORPG.sendToTracking(Unit.getUpdatePacketFor(entity, data), (Entity)entity);
        }
    }

    public static List<EntityType> getIgnoredEntities() {
        if (IGNORED_ENTITIES == null) {
            IGNORED_ENTITIES = ((List)ModConfig.INSTANCE.Server.IGNORED_ENTITIES.get()).stream().filter(x -> ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(x))).map(x -> (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(x))).collect(Collectors.toList());
        }
        return IGNORED_ENTITIES;
    }

    public static boolean shouldSendUpdatePackets(LivingEntity en) {
        return !Unit.getIgnoredEntities().contains(en.func_200600_R());
    }

    public static Object getUpdatePacketFor(LivingEntity en, EntityCap.UnitData data) {
        return new EfficientMobUnitPacket((Entity)en, data);
    }

    public boolean isGearCombinationValid(List<GearItemData> gears, Entity en) {
        List nonWeapons = gears.stream().filter(x -> x.GetBaseGearType().slotType() != GearItemSlot.GearSlotType.Weapon).collect(Collectors.toList());
        int unique_items = (int)nonWeapons.stream().filter(x -> x.isUnique()).count();
        if (unique_items > (Integer)ModConfig.INSTANCE.Server.MAXIMUM_WORN_UNIQUE_ITEMS.get()) {
            if (en instanceof ServerPlayerEntity) {
                en.func_145747_a((ITextComponent)new StringTextComponent("Gear Stats Not Added, reason: you are wearing too many unique items! Maximum Possible Unique items (excluding weapon) : " + ModConfig.INSTANCE.Server.MAXIMUM_WORN_UNIQUE_ITEMS.get()));
            }
            return false;
        }
        int runed_items = (int)nonWeapons.stream().filter(x -> x.isRuned()).count();
        if (runed_items > (Integer)ModConfig.INSTANCE.Server.MAXIMUM_WORN_RUNED_ITEMS.get()) {
            if (en instanceof ServerPlayerEntity) {
                en.func_145747_a((ITextComponent)new StringTextComponent("Gear Stats Not Added, reason: you are wearing too many runed items! Maximum Possible Unique items (excluding weapon) : " + ModConfig.INSTANCE.Server.MAXIMUM_WORN_RUNED_ITEMS.get()));
            }
            return false;
        }
        return true;
    }

    private int countRunedItems(List<GearItemData> gears) {
        int amount = 0;
        for (GearItemData gear : gears) {
            if (!gear.isRuned()) continue;
            ++amount;
        }
        return amount;
    }

    private int countUniqueItems(List<GearItemData> gears) {
        int amount = 0;
        for (GearItemData gear : gears) {
            if (!gear.isUnique()) continue;
            ++amount;
        }
        return amount;
    }

    private Unit Clone() {
        Unit clone = new Unit();
        clone.stats.stats = this.stats.stats != null ? new HashMap<String, StatData>(this.stats.stats) : new HashMap();
        return clone;
    }

    class DirtyCheck {
        int hp;

        DirtyCheck() {
        }

        public boolean isDirty(DirtyCheck newcheck) {
            return newcheck.hp != this.hp;
        }
    }
}

