/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.dungeon_dimension;

import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.new_content.building.DungeonUtils;
import com.robertx22.mine_and_slash.saveclasses.dungeon_dimension.DungeonData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.border.WorldBorder;

@Storable
public class DungeonDimensionData {
    @Store
    private HashMap<String, DungeonData> map = new HashMap();

    public int getDungeonsAmount() {
        return this.map.size();
    }

    public DungeonData getData(BlockPos pos) {
        return this.map.get(DungeonDimensionData.getId(pos));
    }

    public DungeonData getData(ChunkPos pos) {
        return this.map.get(DungeonDimensionData.getId(pos));
    }

    public boolean hasData(BlockPos pos) {
        String id = DungeonDimensionData.getId(pos);
        return this.hasData(id);
    }

    public boolean hasData(ChunkPos pos) {
        String id = DungeonDimensionData.getId(pos);
        return this.hasData(id);
    }

    public boolean hasData(String id) {
        return this.map.containsKey(id) && this.map.get(id) != null;
    }

    public ChunkPos randomFree() {
        return this.randomFree(x -> true);
    }

    public ChunkPos randomFree(Predicate<ChunkPos> filter) {
        String id = "";
        ChunkPos pos = null;
        int tries = 0;
        WorldBorder border = MapManager.getWorld(MapManager.getDungeonDimensionType()).func_175723_af();
        int max = border.func_177722_l() / 16 / 2;
        max = MathHelper.func_76125_a((int)max, (int)0, (int)14999992);
        while (id.isEmpty() || this.hasData(id)) {
            int z;
            if (tries > 2500) {
                System.out.println("Tried too many times to find random dungeon pos and failed, please delete the map dimension folder");
                return null;
            }
            int x = RandomUtils.RandomRange(50, max);
            if (!filter.test(new ChunkPos(x, z = RandomUtils.RandomRange(50, max)))) continue;
            pos = new ChunkPos(x, z);
            pos = DungeonUtils.getStartChunk(pos);
            id = DungeonDimensionData.getId(pos);
        }
        if (tries > 1000) {
            System.out.println("It took more than 1000 tries to find random free dungeon, either you are insanely unlucky, or the world is close to filled! Dungeon worlds are cleared on next server boot if they reach too close to capacity.");
        }
        return pos;
    }

    public static String getId(BlockPos pos) {
        return DungeonDimensionData.getId(DungeonUtils.getStartChunk(new ChunkPos(pos)));
    }

    public static String getId(ChunkPos cpos) {
        cpos = DungeonUtils.getStartChunk(cpos);
        return cpos.field_77276_a + "_" + cpos.field_77275_b;
    }

    public static ChunkPos getChunkFromId(String id) {
        try {
            String[] parts = id.split("_");
            int x = Integer.parseInt(parts[0]);
            int z = Integer.parseInt(parts[1]);
            return new ChunkPos(x, z);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setupNew(DungeonData d, ChunkPos pos) {
        if (!this.hasData(pos)) {
            this.map.put(DungeonDimensionData.getId(pos), d);
        }
    }
}

