/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.chaos_stats.ChaosStat;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.stats.mods.AllTraitMods;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ICreateSpecific;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAffectsOtherStats;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

@Storable
public class ChaosStatsData
implements IStatModsContainer,
ICreateSpecific<StatMod>,
Serializable,
IGearPartTooltip,
IRerollable {
    @Store
    private StatModData chaosStat;

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info, GearItemData gear) {
        int minmax = ((IAffectsOtherStats)((Object)this.chaosStat.getStatMod().GetBaseStat())).percent();
        info.minmax = new MinMax(minmax, minmax);
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (info.hasShiftDown) {
            list.add(Styles.REDCOMP().func_150257_a(Words.Chaos_Stats.locName().func_150258_a(":")));
        }
        for (IStatModsContainer.LevelAndStats part : this.GetAllStats(info.unitdata.getLevel())) {
            for (StatModData data : part.mods) {
                list.addAll(data.GetTooltipString(info));
            }
        }
        return list;
    }

    @Override
    public void RerollFully(GearItemData gear) {
        ChaosStat stat;
        if (gear.chaosStats.chaosStat == null && (stat = SlashRegistry.ChaosStats().getWrapped().allThatMeetRequirement(gear).random()) != null) {
            AllTraitMods mod = new AllTraitMods(stat.getChaosTrait());
            this.create(gear, mod);
        }
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
    }

    @Override
    public void create(GearItemData gear, StatMod mod) {
        this.chaosStat = StatModData.Load(mod, 100);
    }

    @Override
    public IGearPart.Part getPart() {
        return IGearPart.Part.OTHER;
    }

    @Override
    public List<IStatModsContainer.LevelAndStats> GetAllStats(int level) {
        return Arrays.asList(new IStatModsContainer.LevelAndStats(this.chaosStat, level));
    }
}

