/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.rarities.IStatPercents;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.BaseStatContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.StatModTypes;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

@Storable
public class StatModData
extends BaseStatContainer {
    @Store
    private int percent;
    @Store
    private String baseModName;
    private transient boolean useMinimum = true;

    public static StatModData NewRandom(IStatPercents rar, StatMod mod) {
        StatModData data = new StatModData();
        data.baseModName = mod.GUID();
        data.randomize(rar);
        return data;
    }

    public static StatModData NewRandom(MinMax minmax, StatMod mod) {
        StatModData data = new StatModData();
        data.baseModName = mod.GUID();
        data.randomize(minmax);
        return data;
    }

    public static StatModData Load(StatMod mod, int percent) {
        StatModData data = new StatModData();
        data.baseModName = mod.GUID();
        data.percent = percent;
        return data;
    }

    @Override
    public void applyStats(EntityCap.UnitData unit, int level) {
        unit.getUnit().getCreateStat(this.getStatMod().GetBaseStat()).add(this, level);
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int perc) {
        this.percent = perc;
    }

    public void setPercentClamp(MinMax minmax, int perc) {
        this.percent = MathHelper.func_76125_a((int)perc, (int)minmax.min, (int)minmax.max);
    }

    public StatModData noMin() {
        this.useMinimum = false;
        return this;
    }

    public boolean canBeMerged(StatModData mod) {
        return this.baseModName == mod.baseModName;
    }

    public StatModTypes getType() {
        return this.getStatMod().getModType();
    }

    public StatMod getStatMod() {
        return SlashRegistry.StatMods().get(this.baseModName);
    }

    public float getFirstValue(int level) {
        return this.getActualValue(level, FirstSecond.FIRST);
    }

    public float getSecondValue(int level) {
        return this.getActualValue(level, FirstSecond.SECOND);
    }

    public float getActualValue(int level, FirstSecond firstOrSecond) {
        StatMod mod = this.getStatMod();
        Stat stat = mod.GetBaseStat();
        float val = this.useMinimum ? (firstOrSecond.equals((Object)FirstSecond.FIRST) ? this.getFirstActualValue() : this.getSecondActualValue()) : (firstOrSecond.equals((Object)FirstSecond.FIRST) ? this.getFirstActualValueWithoutMin() : this.getSecondActualValueWithoutMin());
        if (mod.getModType().equals((Object)StatModTypes.Flat)) {
            val = stat.calculateScalingStatGrowth(val, level);
        }
        if (stat.isInt) {
            return (int)val;
        }
        return val;
    }

    private float getFirstActualValue() {
        StatMod mod = this.getStatMod();
        return mod.getMin() + (mod.getMax() - mod.getMin()) * (float)this.percent / 100.0f;
    }

    private float getFirstActualValueWithoutMin() {
        StatMod mod = this.getStatMod();
        return mod.getMax() * (float)this.percent / 100.0f;
    }

    private float getSecondActualValue() {
        StatMod mod = this.getStatMod();
        return mod.getMinSecond() + (mod.getMaxSecond() - mod.getMinSecond()) * (float)this.percent / 100.0f;
    }

    private float getSecondActualValueWithoutMin() {
        StatMod mod = this.getStatMod();
        return mod.getMaxSecond() * (float)this.percent / 100.0f;
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        try {
            return this.getStatMod().GetBaseStat().getTooltipList(new TooltipStatInfo(this, info));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Arrays.asList(new StringTextComponent(""));
        }
    }

    public void randomize(IStatPercents rarity) {
        this.randomize(rarity.StatPercents());
    }

    public void randomize(MinMax minmax) {
        this.percent = minmax.random();
    }

    public static enum FirstSecond {
        FIRST,
        SECOND;

    }
}

