/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import info.loenwind.autosave.annotations.Storable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

@Storable
public class StatRequirementsData {
    private HashMap<String, Integer> getReqs(GearItemData data) {
        if (data.isUnique()) {
            try {
                return data.uniqueStats.getUnique().getRequirements().getRequirements(data.level, data.getRarity());
            }
            catch (Exception e) {
                e.printStackTrace();
                return new HashMap<String, Integer>();
            }
        }
        GearItemSlot specific = data.GetBaseGearType();
        return specific.getRequirements().getRequirements(data.getLevel(), data.getRarity());
    }

    public void create(GearItemData data) {
    }

    public static int getAmount(GearItemData data) {
        return StatRequirementsData.getAmount(data.getLevel());
    }

    public static int getAmount(int lvl) {
        int req = (int)((double)((float)lvl - (float)lvl / 6.0f - 5.0f) * (Double)ModConfig.INSTANCE.Server.STAT_REQUIREMENTS_MULTI.get());
        return MathHelper.func_76125_a((int)req, (int)0, (int)100000);
    }

    public boolean meetsRequirements(EntityCap.UnitData data, GearItemData gear) {
        if (data != null && data.getUnit() != null) {
            for (Map.Entry<String, Integer> entry : this.getReqs(gear).entrySet()) {
                if (!SlashRegistry.Stats().isRegistered(entry.getKey())) continue;
                if (entry.getValue() <= 0) {
                    return true;
                }
                if (!data.getUnit().getStats().containsKey(entry.getKey())) {
                    return false;
                }
                if (!(data.getUnit().peekAtStat(entry.getKey()).getAverageValue() < (float)entry.getValue().intValue())) continue;
                return false;
            }
        }
        return true;
    }

    public List<ITextComponent> GetTooltipString(TooltipInfo info, GearItemData gear) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        for (Map.Entry<String, Integer> entry : this.getReqs(gear).entrySet()) {
            if (entry.getValue() <= 0 || !SlashRegistry.Stats().isRegistered(entry.getKey())) continue;
            Stat stat = SlashRegistry.Stats().get(entry.getKey());
            list.add(TooltipUtils.requirement(stat.locName(), (int)info.unitdata.getUnit().getCreateStat(stat).getAverageValue(), entry.getValue()));
        }
        return list;
    }
}

