/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.database.affixes.BaseAffix;
import com.robertx22.mine_and_slash.database.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.db_lists.initializers.Suffixes;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.AffixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ICreateSpecific;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import info.loenwind.autosave.annotations.Storable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

@Storable
public class SuffixData
extends AffixData
implements ICreateSpecific<BaseAffix>,
Serializable,
IGearPartTooltip,
IRerollable {
    private static final long serialVersionUID = 8802998468539898482L;

    public SuffixData() {
    }

    public SuffixData(GearItemData gear, String affixname, List<Integer> percents) {
        this.baseAffix = affixname;
        this.percents = percents;
    }

    @Override
    public void create(GearItemData gear, BaseAffix suffix) {
        this.baseAffix = suffix.GUID();
        this.RerollNumbers(gear);
    }

    @Override
    public void RerollFully(GearItemData gear) {
        BaseAffix suffix = (BaseAffix)Suffixes.INSTANCE.random(new GearRequestedFor(gear));
        this.create(gear, suffix);
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.percents = new ArrayList();
        for (StatMod mod : this.BaseAffix().StatMods()) {
            this.percents.add(this.getMinMax(gear).random());
        }
    }

    @Override
    public BaseAffix BaseAffix() {
        return SlashRegistry.Affixes().get(this.baseAffix);
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info, GearItemData gear) {
        info.minmax = this.getMinMax(gear);
        BaseAffix affix = this.BaseAffix();
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add(Styles.GRAYCOMP().func_150257_a(Words.Suffix.locName().func_150258_a(": ").func_150257_a(affix.locName())));
        for (IStatModsContainer.LevelAndStats part : this.GetAllStats(info.level)) {
            for (StatModData data : part.mods) {
                list.addAll(data.GetTooltipString(info));
            }
        }
        return list;
    }

    @Override
    public IGearPart.Part getPart() {
        return IGearPart.Part.AFFIX;
    }
}

