/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem;

import com.robertx22.mine_and_slash.database.stats.StatMod;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

@Storable
public class UniqueStatsData
implements IGearPartTooltip,
IRerollable,
IStatModsContainer {
    @Store
    public String uniqueGUID;
    @Store
    public List<Integer> percents = new ArrayList<Integer>();

    public UniqueStatsData() {
    }

    public UniqueStatsData(String GUID) {
        this.uniqueGUID = GUID;
    }

    @Override
    public void RerollFully(GearItemData gear) {
        this.RerollNumbers(gear);
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.percents.clear();
        for (int i = 0; i < 10; ++i) {
            this.percents.add(this.getMinMax(gear).random());
        }
    }

    public ITextComponent getHeader() {
        return new StringTextComponent(Styles.YELLOW + "").func_150257_a(Words.Unique_Stats.locName().func_150258_a(":"));
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info, GearItemData gear) {
        info.minmax = this.getMinMax(gear);
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        list.add((ITextComponent)new SText(""));
        list.add(this.getHeader());
        for (IStatModsContainer.LevelAndStats part : this.GetAllStats(info.level)) {
            for (StatModData data : part.mods) {
                list.addAll(data.GetTooltipString(info));
            }
        }
        return list;
    }

    public IUnique getUnique() {
        return SlashRegistry.UniqueGears().get(this.uniqueGUID);
    }

    @Override
    public List<IStatModsContainer.LevelAndStats> GetAllStats(int level) {
        IUnique unique = this.getUnique();
        ArrayList<StatModData> list = new ArrayList<StatModData>();
        for (int i = 0; i < unique.uniqueStats().size(); ++i) {
            StatMod mod = unique.uniqueStats().get(i);
            list.add(StatModData.Load(mod, this.percents.get(i)));
        }
        return Arrays.asList(new IStatModsContainer.LevelAndStats(list, level));
    }

    @Override
    public IGearPart.Part getPart() {
        return IGearPart.Part.UNIQUE_STATS;
    }
}

