/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases;

import com.robertx22.mine_and_slash.database.MinMax;
import com.robertx22.mine_and_slash.database.stats.tooltips.StatTooltipType;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TooltipInfo
implements Cloneable {
    public boolean showAbilityExtraInfo = true;
    public PlayerEntity player;
    public EntityCap.UnitData unitdata;
    public MinMax minmax = new MinMax(0, 100);
    public int level;
    public boolean isSet = false;
    public StatTooltipType statTooltipType = StatTooltipType.NORMAL;
    public boolean hasAltDown = false;
    public boolean hasShiftDown = false;

    public TooltipInfo(EntityCap.UnitData unitdata, MinMax minmax, int level) {
        this.minmax = minmax;
        this.level = level;
        this.unitdata = unitdata;
        this.hasAltDown = Screen.hasAltDown();
        this.hasShiftDown = Screen.hasShiftDown();
    }

    public TooltipInfo(EntityCap.UnitData unitdata, int level) {
        this.minmax = new MinMax(100, 100);
        this.level = level;
        this.unitdata = unitdata;
        this.hasAltDown = Screen.hasAltDown();
        this.hasShiftDown = Screen.hasShiftDown();
    }

    public TooltipInfo() {
        this.hasAltDown = Screen.hasAltDown();
        this.hasShiftDown = Screen.hasShiftDown();
    }

    public TooltipInfo(PlayerEntity player) {
        this.player = player;
        this.unitdata = Load.Unit((ICapabilityProvider)player);
        this.level = this.unitdata.getLevel();
        this.minmax = new MinMax(100, 100);
        this.hasAltDown = Screen.hasAltDown();
        this.hasShiftDown = Screen.hasShiftDown();
    }

    public TooltipInfo setIsSet() {
        this.isSet = true;
        return this;
    }

    public boolean shouldShowDescriptions() {
        return this.hasAltDown && !this.hasShiftDown && !this.isSet;
    }

    public boolean useInDepthStats() {
        return !this.hasAltDown && this.hasShiftDown && !this.isSet;
    }

    public TooltipInfo withLevel(int level) {
        TooltipInfo info = null;
        try {
            info = (TooltipInfo)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        info.level = level;
        return info;
    }
}

