/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.mine_and_slash.config.forge.ClientContainer;
import com.robertx22.mine_and_slash.database.gearitemslots.WeaponSwingCost;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.database.stats.types.resources.Mana;
import com.robertx22.mine_and_slash.database.unique_items.IUnique;
import com.robertx22.mine_and_slash.items.gearitems.offhands.IEffectItem;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatModsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.MergedStats;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class GearTooltipUtils {
    public static void BuildTooltip(GearItemData gear, ItemStack stack, ItemTooltipEvent event, EntityCap.UnitData data) {
        BaseSpell spell;
        IUnique unique;
        List tip = event.getToolTip();
        TooltipInfo info = new TooltipInfo(data, gear.getRarity().StatPercents(), gear.level);
        GearItemSlot slot = gear.GetBaseGearType();
        tip.clear();
        tip.add(gear.GetDisplayName(stack));
        if (!gear.isIdentified()) {
            tip.add(new SText(""));
            tip.add(Styles.GRAYCOMP().func_150257_a(Words.ItemIsUnidentified.locName()));
            tip.add(Styles.GRAYCOMP().func_150257_a(Words.UseAnIdentifyScroll.locName()));
            tip.add(new SText(""));
            tip.add(TooltipUtils.lvlReq(gear.level, data));
            return;
        }
        if (gear.primaryStats != null) {
            tip.addAll(gear.primaryStats.GetTooltipString(info, gear));
        }
        tip.add(new StringTextComponent(""));
        ArrayList<IGearPartTooltip> list = new ArrayList<IGearPartTooltip>();
        tip.add(TooltipUtils.lvlReq(gear.level, data));
        if (gear.requirements != null) {
            tip.addAll(gear.requirements.GetTooltipString(info, gear));
        }
        if (gear.runes != null) {
            tip.addAll(gear.runes.GetTooltipString(info, gear));
        }
        if (gear.uniqueStats != null) {
            tip.addAll(gear.uniqueStats.GetTooltipString(info, gear));
        }
        tip.add(new StringTextComponent(""));
        if (Screen.hasShiftDown()) {
            list.add(gear.secondaryStats);
            list.add(gear.prefix);
            list.add(gear.suffix);
        } else {
            ArrayList<IStatModsContainer.LevelAndStats> lvlstatsmerged = new ArrayList<IStatModsContainer.LevelAndStats>();
            if (gear.secondaryStats != null) {
                lvlstatsmerged.addAll(gear.secondaryStats.GetAllStats(gear.level));
            }
            if (gear.suffix != null) {
                lvlstatsmerged.addAll(gear.suffix.GetAllStats(gear.level));
            }
            if (gear.prefix != null) {
                lvlstatsmerged.addAll(gear.prefix.GetAllStats(gear.level));
            }
            MergedStats merged = new MergedStats(lvlstatsmerged, info);
            list.add(merged);
        }
        list.add(gear.chaosStats);
        list.add(gear.set);
        for (IGearPartTooltip part : list) {
            if (part == null) continue;
            tip.addAll(part.GetTooltipString(info, gear));
            tip.add(new StringTextComponent(""));
        }
        if (Screen.hasShiftDown()) {
            boolean addRarityTooltip = true;
            if (gear.isUnique) {
                unique = gear.uniqueStats.getUnique();
                addRarityTooltip = false;
                tip.add(new StringTextComponent(""));
            }
            if (addRarityTooltip) {
                // empty if block
            }
        }
        GearRarity rarity = gear.getRarity();
        tip.add(TooltipUtils.rarity(rarity));
        if (Screen.hasShiftDown() && !gear.isSalvagable) {
            tip.add(Styles.REDCOMP().func_150257_a(Words.Unsalvagable.locName()));
        }
        if (Screen.hasShiftDown() && slot.isWeapon()) {
            WeaponSwingCost costs = slot.getSwingCosts();
            tip.add(new StringTextComponent(""));
            if (costs.GetEnergyCost(data.getLvlForResourceCosts()) > 0.0f) {
                tip.add(Styles.GREENCOMP().func_150257_a(Energy.getInstance().locName().func_150258_a(": " + (int)costs.GetEnergyCost(gear.getLevel()))));
            }
            if (costs.GetManaCost(data.getLvlForResourceCosts()) > 0.0f) {
                tip.add(Styles.BLUECOMP().func_150257_a(Mana.getInstance().locName().func_150258_a(": " + (int)costs.GetManaCost(gear.getLevel()))));
            }
            tip.addAll(slot.weaponDamageMulti().tooltipDesc());
            tip.addAll(slot.getWeaponMechanic().tooltipDesc());
        }
        if (Screen.hasShiftDown() && gear.usesInstability()) {
            event.getToolTip().add(TooltipUtils.instability(gear));
        }
        if (Screen.hasShiftDown() && stack.func_77973_b() instanceof IEffectItem) {
            IEffectItem effect = (IEffectItem)stack.func_77973_b();
            event.getToolTip().addAll(effect.getEffectTooltip(Screen.hasShiftDown()));
        }
        if (gear.isUnique) {
            unique = gear.uniqueStats.getUnique();
            List<String> lores = TooltipUtils.cutIfTooLong(CLOC.translate(unique.locDesc()));
            tip.add(new StringTextComponent(""));
            int i = 0;
            for (String desc : lores) {
                ITextComponent comp = Styles.GREENCOMP();
                if (i == 0) {
                    comp.func_150258_a("'");
                }
                comp.func_150258_a(desc);
                if (i == lores.size() - 1) {
                    comp.func_150258_a("'");
                }
                ++i;
                tip.add(comp);
            }
        }
        tip.add(new StringTextComponent(""));
        if (!Screen.hasShiftDown()) {
            event.getToolTip().add(Styles.BLUECOMP().func_150257_a(CLOC.tooltip("press_shift_more_info")));
        }
        if ((spell = gear.getRightClickSpell()) != null) {
            tip.add(new SText(""));
            tip.add(new SText(spell.getElement().format + "Right click: ").func_150257_a(spell.getName().locName()));
        }
        if (Screen.hasShiftDown()) {
            // empty if block
        }
        List<ITextComponent> tool = TooltipUtils.removeDoubleBlankLines(tip, (Integer)ClientContainer.INSTANCE.REMOVE_EMPTY_TOOLTIP_LINES_IF_MORE_THAN_X_LINES.get());
        tip.clear();
        tip.addAll(tool);
    }
}

