/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.rarities.MapRarity;
import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.db_lists.bases.IBonusLootMulti;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.mapitem.MapAffixData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.ItemType;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.Map;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AffectedEntities;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ITiered;
import com.robertx22.mine_and_slash.uncommon.localization.CLOC;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ParticleUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Storable
public class MapItemData
implements ICommonDataItem<MapRarity>,
IBonusLootMulti,
Cloneable {
    @Store
    public int level = 1;
    @Store
    public int tier = 0;
    @Store
    public int rarity = 0;
    @Store
    public boolean isExp = false;
    @Store
    public List<MapAffixData> affixes = new ArrayList<MapAffixData>();
    @Store
    private String dimID = "mmorpg:resettable_dungeon";
    @Store
    public String mapUUID = UUID.randomUUID().toString();
    private static MapItemData empty;
    @Store
    public String worldGeneratorName = "dungeon";

    public DimensionType getDimension() {
        String id = this.dimID == null || this.dimID.isEmpty() ? "mmorpg:resettable_dungeon" : this.dimID;
        DimensionType type = MapManager.getDimensionType(new ResourceLocation(this.dimID));
        return type;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        Map.Save(stack, this);
    }

    public static MapItemData empty() {
        if (empty == null) {
            empty = new MapItemData();
            MapItemData.empty.mapUUID = "error";
        }
        return empty;
    }

    public boolean isEmpty() {
        return this.mapUUID == null || this.mapUUID.isEmpty() || this.mapUUID.equals("error");
    }

    public MapItemData clone() {
        CompoundNBT nbt = new CompoundNBT();
        Map.Save(nbt, this);
        return Map.Load(nbt);
    }

    @Nonnull
    public IWP getIWP() {
        return SlashRegistry.WorldProviders().get(this.worldGeneratorName);
    }

    @Override
    public float getBonusLootMulti() {
        if (this.isExp) {
            return 1.0f;
        }
        return 1.0f + this.bonusFormula();
    }

    public float bonusFormula() {
        return 1.0f * this.getAffixMulti();
    }

    public float getBonusExpMulti() {
        if (this.isExp) {
            return 1.0f + this.bonusFormula() * 2.0f;
        }
        return 1.0f;
    }

    public boolean increaseLevel(int i) {
        int lvl = this.level + i;
        if (lvl > (Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()) {
            return false;
        }
        this.level = lvl;
        return true;
    }

    public boolean increaseTier(int i) {
        int tier = this.tier + i;
        if (tier > ITiered.getMaxTier()) {
            return false;
        }
        this.tier = tier;
        return true;
    }

    private float getAffixMulti() {
        float total = 0.0f;
        for (MapAffixData affix : this.affixes) {
            total += affix.getBonusLootMultiplier();
        }
        return total;
    }

    public static List<MapAffixData> getAllAffixesThatAffect(List<MapAffixData> affixes, LivingEntity entity) {
        AffectedEntities affected = AffectedEntities.All;
        if (entity instanceof PlayerEntity) {
            affected = AffectedEntities.Players;
        } else if (EntityTypeUtils.isMob((Entity)entity)) {
            affected = AffectedEntities.Mobs;
        }
        return MapItemData.getAllAffixesThatAffect(affixes, affected);
    }

    public static List<MapAffixData> getAllAffixesThatAffect(List<MapAffixData> affixes, AffectedEntities affected) {
        ArrayList<MapAffixData> list = new ArrayList<MapAffixData>();
        for (MapAffixData data : affixes) {
            if (!data.affectedEntities.equals((Object)affected)) continue;
            list.add(data);
        }
        return list;
    }

    @Override
    public String getUniqueGUID() {
        return this.worldGeneratorName;
    }

    public List<MapAffixData> getAllAffixesThatAffect(AffectedEntities affected) {
        ArrayList<MapAffixData> list = new ArrayList<MapAffixData>();
        for (MapAffixData data : this.affixes) {
            if (!data.affectedEntities.equals((Object)affected)) continue;
            list.add(data);
        }
        for (MapAffixData data : this.getIWP().getMapAffixes()) {
            if (!data.affectedEntities.equals((Object)affected)) continue;
            list.add(data);
        }
        return list;
    }

    public DimensionType setupPlayerMapData(BlockPos pos, PlayerEntity player) {
        EntityCap.UnitData unit = Load.Unit((ICapabilityProvider)player);
        ParticleUtils.spawnEnergyRestoreParticles((LivingEntity)player, 10);
        return MapManager.setupPlayerMapDimension(player, unit, this, pos);
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        int min = this.tryIncreaseAmount(salvageBonus, 2);
        int max = this.tryIncreaseAmount(salvageBonus, 4);
        ItemStack stack = ItemStack.field_190927_a;
        if (RandomUtils.roll(this.getRarity().salvageLotteryWinChance())) {
            Item item = SlashRegistry.CurrencyItems().getWrapped().ofCurrencyUsableOnItemType(ItemType.MAP).random();
            stack = new ItemStack((IItemProvider)item);
        } else {
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.rarity);
            stack = new ItemStack((IItemProvider)ore);
            stack.func_190920_e(amount);
        }
        return stack;
    }

    @Override
    public DataItemType getDataType() {
        return DataItemType.MAP;
    }

    public List<ITextComponent> getTooltip() {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        GearRarity rarity = (GearRarity)Rarities.Gears.get(this.rarity);
        tooltip.add(TooltipUtils.level(this.level));
        TooltipUtils.addEmpty(tooltip);
        MapItemData.addAffixTypeToTooltip(this, tooltip, AffectedEntities.Mobs);
        MapItemData.addAffixTypeToTooltip(this, tooltip, AffectedEntities.Players);
        MapItemData.addAffixTypeToTooltip(this, tooltip, AffectedEntities.All);
        TooltipUtils.addEmpty(tooltip);
        try {
            tooltip.add(Styles.BLUECOMP().func_150257_a(Words.World_Type.locName()).func_150258_a(": ").func_150257_a(this.getIWP().locName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TooltipUtils.addEmpty(tooltip);
        ITextComponent comp = TooltipUtils.rarityShort(rarity).func_150258_a(TextFormatting.GRAY + ", ").func_150257_a(Styles.YELLOWCOMP());
        boolean addedExp = false;
        if (this.getBonusExpAmountInPercent() > 0) {
            comp.func_150257_a(Words.Exp.locName().func_150258_a(": +" + this.getBonusExpAmountInPercent() + "%"));
            addedExp = true;
        }
        if (this.getBonusLootAmountInPercent() > 0) {
            if (addedExp) {
                comp.func_150258_a(", ");
            }
            comp.func_150257_a(Words.Loot.locName().func_150258_a(": +" + this.getBonusLootAmountInPercent() + "%"));
        }
        comp.func_150258_a(TextFormatting.GRAY + ", ").func_150257_a(Styles.GOLDCOMP().func_150257_a(Words.Tier.locName().func_150258_a(": " + this.tier)));
        tooltip.add(comp);
        TooltipUtils.addEmpty(tooltip);
        tooltip.add(Styles.BLUECOMP().func_150257_a(CLOC.tooltip("put_in_mapdevice")));
        TooltipUtils.removeDoubleBlankLines(tooltip, 20);
        return tooltip;
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        if (ctx.data != null) {
            ctx.event.getToolTip().addAll(this.getTooltip());
        }
    }

    private int getBonusLootAmountInPercent() {
        return (int)((this.getBonusLootMulti() - 1.0f) * 100.0f);
    }

    private int getBonusExpAmountInPercent() {
        return (int)((this.getBonusExpMulti() - 1.0f) * 100.0f);
    }

    private static void addAffixTypeToTooltip(MapItemData data, List<ITextComponent> tooltip, AffectedEntities affected) {
        ArrayList<MapAffixData> affixes = new ArrayList<MapAffixData>(data.getAllAffixesThatAffect(affected));
        if (affixes.size() == 0) {
            return;
        }
        StringTextComponent str = new StringTextComponent("");
        if (affected.equals((Object)AffectedEntities.Players)) {
            str.func_150257_a(Words.Player_Affixes.locName());
        } else if (affected.equals((Object)AffectedEntities.Mobs)) {
            str.func_150257_a(Words.Mob_Affixes.locName());
        } else {
            str.func_150257_a(Words.Affixes_Affecting_All.locName());
        }
        tooltip.add(Styles.GREENCOMP().func_150257_a((ITextComponent)str));
        for (MapAffixData affix : affixes) {
            for (StatModData statmod : affix.getAffix().Stats(affix.percent)) {
                TooltipInfo info = new TooltipInfo(new EntityCap.DefaultImpl(), data.getRarity().StatPercents(), data.level);
                tooltip.addAll(statmod.GetTooltipString(info));
            }
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    @Override
    public int getRarityRank() {
        return MathHelper.func_76125_a((int)this.rarity, (int)-1, (int)4);
    }

    public MapRarity getRarity() {
        return (MapRarity)Rarities.Maps.get(this.rarity);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getSpecificType() {
        return this.worldGeneratorName;
    }
}

