/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.rarities.RuneRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.ItemType;
import com.robertx22.mine_and_slash.uncommon.datasaving.Rune;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.DataItemType;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

@Storable
public class RuneItemData
implements ICommonDataItem<RuneRarity> {
    @Store
    public String name;
    @Store
    public int level = 1;
    @Store
    public int tier = 0;
    @Store
    public int rarity = 0;
    @Store
    public StatModData weapon;
    @Store
    public StatModData armor;
    @Store
    public StatModData jewerly;

    @Override
    public void saveToStack(ItemStack stack) {
        Rune.Save(stack, this);
    }

    @Override
    public String getUniqueGUID() {
        return this.name;
    }

    public StatModData getModFor(GearItemData gear) {
        GearItemSlot slot = gear.GetBaseGearType();
        if (slot.slotType().equals((Object)GearItemSlot.GearSlotType.Armor)) {
            return this.armor;
        }
        if (slot.slotType().equals((Object)GearItemSlot.GearSlotType.Jewerly)) {
            return this.jewerly;
        }
        return this.weapon;
    }

    @Override
    public ItemStack getSalvageResult(float salvageBonus) {
        int min = this.tryIncreaseAmount(salvageBonus, 1);
        int max = this.tryIncreaseAmount(salvageBonus, 2);
        if (this.rarity == 0) {
            max = 1;
        }
        ItemStack stack = ItemStack.field_190927_a;
        if (RandomUtils.roll(this.getRarity().salvageLotteryWinChance())) {
            Item item = SlashRegistry.CurrencyItems().getWrapped().ofCurrencyUsableOnItemType(ItemType.GEAR).ofTierOrLess(this.rarity + 10).random();
            stack = new ItemStack((IItemProvider)item);
        } else {
            int amount = RandomUtils.RandomRange(min, max);
            ItemOre ore = (ItemOre)ItemOre.ItemOres.get(this.getSalvagedOreRarity(this.getRarityRank()));
            stack = new ItemStack((IItemProvider)ore);
            stack.func_190920_e(amount);
        }
        return stack;
    }

    @Override
    public DataItemType getDataType() {
        return DataItemType.RUNE;
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        List tooltip = ctx.event.getToolTip();
        RuneItemData rune = Rune.Load(ctx.stack);
        if (rune != null) {
            tooltip.add(TooltipUtils.level(rune.level));
            RuneRarity rar = rune.getRarity();
            TooltipInfo info = new TooltipInfo(new EntityCap.DefaultImpl(), rar.StatPercents(), rune.level);
            if (rune.armor != null) {
                tooltip.add(Styles.GRAYCOMP().func_150257_a(Words.Armor.locName().func_150258_a(":")));
                for (ITextComponent str : rune.armor.GetTooltipString(info)) {
                    tooltip.add(str);
                }
                TooltipUtils.addEmpty(tooltip);
            }
            if (rune.weapon != null) {
                tooltip.add(Styles.GRAYCOMP().func_150257_a(Words.WeaponOffhand.locName().func_150258_a(":")));
                for (ITextComponent str : rune.weapon.GetTooltipString(info)) {
                    tooltip.add(str);
                }
            }
            if (rune.jewerly != null) {
                TooltipUtils.addEmpty(tooltip);
                tooltip.add(Styles.GRAYCOMP().func_150257_a(Words.Jewerly.locName().func_150258_a(":")));
                for (ITextComponent str : rune.jewerly.GetTooltipString(info)) {
                    tooltip.add(str);
                }
                TooltipUtils.addEmpty(tooltip);
            }
            tooltip.add(TooltipUtils.rarity(rune.getRarity()));
            if (this.tier > 0) {
                TooltipUtils.addEmpty(tooltip);
                tooltip.add(TooltipUtils.tier(this.tier));
            }
            TooltipUtils.addEmpty(tooltip);
            tooltip.add(Styles.BLUECOMP().func_150257_a(Words.Item_modifiable_in_station.locName()));
        }
    }

    @Override
    public int getRarityRank() {
        return MathHelper.func_76125_a((int)this.rarity, (int)-1, (int)4);
    }

    public RuneRarity getRarity() {
        return (RuneRarity)Rarities.Runes.get(this.rarity);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public String getSpecificType() {
        return this.name;
    }
}

