/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import net.minecraft.util.math.MathHelper;

@Storable
public class AbilityData {
    @Store
    private int currentLvl = 0;
    @Store
    private int bonusLvls = 0;
    @Store
    public String id = "";
    @Store
    public IAbility.Type type = IAbility.Type.SPELL;

    public AbilityData(String id, IAbility.Type type) {
        this.id = id;
        this.type = type;
    }

    public void setBonusLvl(int lvl) {
        this.bonusLvls = lvl;
    }

    public int getBonusLvls() {
        return this.bonusLvls;
    }

    public void setLevel(int i) {
        this.currentLvl = i;
    }

    public void addLevels(int i) {
        this.currentLvl = MathHelper.func_76125_a((int)(this.currentLvl + i), (int)0, (int)this.getAbility().getMaxSpellLevelNormal());
    }

    public int getCurrentLevel() {
        this.currentLvl = MathHelper.func_76125_a((int)this.currentLvl, (int)0, (int)this.getAbility().getMaxSpellLevelNormal());
        if (this.currentLvl < 1) {
            return this.currentLvl;
        }
        return MathHelper.func_76125_a((int)(this.currentLvl + this.bonusLvls), (int)0, (int)this.getAbility().getMaxSpellLevelBuffed());
    }

    public AbilityData(IAbility ability) {
        this.id = ability.GUID();
        this.type = ability.getAbilityType();
    }

    public AbilityData() {
    }

    public boolean isValid() {
        if (this.id == null || this.id.isEmpty()) {
            return false;
        }
        if (this.currentLvl < 1) {
            return false;
        }
        if (this.type == IAbility.Type.SPELL) {
            return SlashRegistry.Spells().isRegistered(this.id);
        }
        if (this.type == IAbility.Type.EFFECT) {
            return SlashRegistry.PotionEffects().isRegistered(this.id);
        }
        if (this.type == IAbility.Type.SYNERGY) {
            return SlashRegistry.Synergies().isRegistered(this.id);
        }
        return false;
    }

    public IAbility getAbility() {
        if (this.type == IAbility.Type.SPELL) {
            return SlashRegistry.Spells().get(this.id);
        }
        if (this.type == IAbility.Type.SYNERGY) {
            return SlashRegistry.Synergies().get(this.id);
        }
        if (this.type == IAbility.Type.EFFECT) {
            return SlashRegistry.PotionEffects().get(this.id);
        }
        return null;
    }
}

