/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IApplyableStats;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityData;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Storable
public class AllocatedAbilitiesData
implements IApplyableStats {
    @Store
    public int resetPoints = 0;
    @Store
    public HashMap<String, AbilityData> map = new HashMap();
    @Store
    public HashMap<String, Integer> schoolPoints = new HashMap();
    private static AbilityData EMPTY_ABILITY = new AbilityData();

    public int getSchoolPoints(Masteries school) {
        return this.schoolPoints.getOrDefault(school.name(), 0);
    }

    public HashMap<String, AbilityData> getAbilityMap() {
        return this.map;
    }

    public void clearBonusLevels() {
        this.map.entrySet().forEach(x -> ((AbilityData)x.getValue()).setBonusLvl(0));
    }

    public void addBonusAbilityLevelsTo(Masteries school, int lvls) {
        this.map.entrySet().forEach(e -> {
            if (((AbilityData)e.getValue()).getAbility().getMastery().equals((Object)school)) {
                ((AbilityData)e.getValue()).setBonusLvl(((AbilityData)e.getValue()).getBonusLvls() + lvls);
            }
        });
    }

    public boolean canRemoveSchoolPoint(Masteries school) {
        if (this.resetPoints < 1) {
            return false;
        }
        int points = this.getSchoolPoints(school);
        if (points < 1) {
            return false;
        }
        for (Map.Entry<String, AbilityData> entry : this.map.entrySet()) {
            IAbility ability;
            if (!entry.getValue().isValid() || !(ability = entry.getValue().getAbility()).getMastery().equals((Object)school) || ability.getSchoolPointsNeeded() <= points - 1) continue;
            return false;
        }
        return true;
    }

    public boolean canAddPointsToSchool(Masteries school, EntityCap.UnitData data) {
        if (this.getFreeAbilityPoints(data) < 1) {
            return false;
        }
        if (data.getLevel() < Masteries.LVL_TO_UNLOCK_2ND_SCHOOL && this.getSchoolsWithAllocatedPoints() == 1 && this.getSchoolPoints(school) < 1) {
            return false;
        }
        if (this.getSchoolsWithAllocatedPoints() > 1 && this.getSchoolPoints(school) < 1) {
            return false;
        }
        return this.getSchoolPoints(school) < Masteries.MAXIMUM_POINTS;
    }

    public int getSchoolsWithAllocatedPoints() {
        int i = 0;
        for (Map.Entry<String, Integer> x : this.schoolPoints.entrySet()) {
            if (x.getValue() <= 0) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void applyStats(EntityCap.UnitData data, int level) {
        try {
            this.schoolPoints.entrySet().forEach(x -> {
                Masteries school = Masteries.valueOf((String)x.getKey());
                int points = (Integer)x.getValue();
                school.getStatsFor(points, data).forEach(s -> s.applyStats(data));
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLevel(IAbility ability, int lvl) {
        AbilityData data = new AbilityData(ability);
        data.setLevel(lvl);
        this.map.put(ability.GUID(), data);
    }

    public List<BaseSpell> getAllocatedSpells() {
        ArrayList<BaseSpell> list = new ArrayList<BaseSpell>();
        this.map.values().forEach(x -> {
            if (x.isValid() && x.getCurrentLevel() > 0 && x.type == IAbility.Type.SPELL) {
                list.add((BaseSpell)x.getAbility());
            }
        });
        return list;
    }

    public List<Synergy> getAllocatedSynergies() {
        ArrayList<Synergy> list = new ArrayList<Synergy>();
        this.map.values().forEach(x -> {
            if (x.isValid() && x.getCurrentLevel() > 0 && x.type == IAbility.Type.SYNERGY) {
                list.add((Synergy)x.getAbility());
            }
        });
        return list;
    }

    public void addSchoolPoint(Masteries school) {
        int points = this.schoolPoints.getOrDefault(school.name(), 0) + 1;
        this.schoolPoints.put(school.name(), points);
    }

    public void removeSchoolPoint(Masteries school) {
        --this.resetPoints;
        int points = this.schoolPoints.getOrDefault(school.name(), 0) - 1;
        this.schoolPoints.put(school.name(), points);
    }

    public int getAllocatedAbilityPoints() {
        int points = 0;
        for (AbilityData abilityData : this.map.values()) {
            if (!abilityData.isValid()) continue;
            points += abilityData.getCurrentLevel();
        }
        for (Integer n : this.schoolPoints.values()) {
            points += n.intValue();
        }
        return points;
    }

    public int getTotalAllowedAbilityPoints(EntityCap.UnitData data) {
        int perlvl = (int)((float)((Integer)ModConfig.INSTANCE.Server.SPELL_POINTS_AT_MAX_LEVEL.get()).intValue() / (float)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()).intValue() * (float)data.getLevel());
        int starting = (Integer)ModConfig.INSTANCE.Server.STARTING_SPELL_POINTS.get();
        return starting + perlvl;
    }

    public int getFreeAbilityPoints(EntityCap.UnitData data) {
        return this.getTotalAllowedAbilityPoints(data) - this.getAllocatedAbilityPoints();
    }

    public boolean canAddPointsOrHasPoints(IAbility ability, EntityCap.UnitData data) {
        if (this.canAddPoints(ability, data)) {
            return true;
        }
        return this.getLevelOf(ability) > 0;
    }

    public boolean canAddPoints(IAbility ability, EntityCap.UnitData data) {
        int needed;
        if (this.getFreeAbilityPoints(data) < 1) {
            return false;
        }
        if (ability.getRequiredAbility() != null && this.getLevelOf(ability.getRequiredAbility()) < 1) {
            return false;
        }
        int current = this.schoolPoints.getOrDefault(ability.getMastery().name(), 0);
        return current >= (needed = ability.getSchoolPointsNeeded());
    }

    public int getLevelOf(IAbility ability) {
        return this.map.getOrDefault(ability.GUID(), EMPTY_ABILITY).getCurrentLevel();
    }

    public int getLevelOf(String id) {
        return this.map.getOrDefault(id, EMPTY_ABILITY).getCurrentLevel();
    }

    public boolean isAllocated(IAbility ability) {
        return this.getLevelOf(ability) > 0;
    }

    public boolean isAllocated(String id) {
        return this.getLevelOf(id) > 0;
    }

    public void addPoint(IAbility ability) {
        if (!this.map.containsKey(ability.GUID())) {
            this.map.put(ability.GUID(), new AbilityData(ability));
        }
        this.map.get(ability.GUID()).addLevels(1);
    }

    public void removePoint(IAbility ability) {
        --this.resetPoints;
        if (!this.map.containsKey(ability.GUID())) {
            this.map.put(ability.GUID(), new AbilityData(ability));
        }
        this.map.get(ability.GUID()).addLevels(-1);
    }

    public void reset() {
        this.map.clear();
        this.schoolPoints.clear();
    }

    public void clean() {
        new HashMap<String, AbilityData>(this.map).entrySet().forEach(x -> {
            if (!((AbilityData)x.getValue()).isValid()) {
                this.map.remove(x.getKey());
            }
        });
    }
}

